<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remositoryAdminStats extends remositoryAdminControllers {

	function remositoryAdminStats ($admin) {
		remositoryAdminControllers::remositoryAdminControllers ($admin);
	    $_REQUEST['act'] = 'stats';
	}

	function listTask (){
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();

		// Top 5 Downloads
		$sql="SELECT downloads, filetitle from #__downloads_files ORDER BY downloads DESC LIMIT 5";
		$database->setQuery( $sql );
		$downloads = $database->loadObjectList();

		// Top 5 Rated
		$logtype = _REM_VOTE_USER_GENERAL;
		$sql="SELECT CONCAT(filetitle,',',ROUND(AVG(value),1)), AVG(value) as average FROM #__downloads_log as l, #__downloads_files as f WHERE l.type=$logtype AND f.id = l.fileid GROUP BY f.id ORDER BY average DESC LIMIT 5";
		$database->setQuery( $sql );
		$ratings = $database->loadResultArray();

		// Top 5 Voted
		$sql="SELECT CONCAT(filetitle,',',COUNT(l.id)), COUNT(l.id) as counter FROM #__downloads_log as l, #__downloads_files as f WHERE l.type=$logtype AND f.id = l.fileid GROUP BY f.id ORDER BY counter DESC LIMIT 5";
		$database->setQuery( $sql );
		$votes = $database->loadResultArray();

		$view = $this->admin->newHTMLClassCheck ('listStatsHTML', $this, 0, '');
		if ($view AND $this->admin->checkCallable($view, 'view')) $view->view($downloads, $ratings, $votes);
	}

}

?>