<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remository_download_Controller extends remositoryUserControllers {

	function download ($func) {
		$debugmissing = true;
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$mosConfig_live_site = $interface->getCfg('live_site');
		$ua = remositoryRepository::getParam($_SERVER, 'HTTP_USER_AGENT');
		$scribd = (false !== strpos($ua, 'Scribdbot') AND false !== strpos($ua, 'http://www.scribd.com'));
		if (!isset($_GET['chk']) OR $this->repository->wrongCheck($_GET['chk'],$this->idparm,'download')){
			die('Illegal download attempt');
		}
		// Following two lines needed for com_remository_startdown operation
		// $chk = $this->repository->makeCheck($this->idparm,'startdown');
		// header("Location: $mosConfig_live_site/components/com_remository/com_remository_startdown.php?id=$this->idparm&chk=$chk&userid={$this->remUser->id}");
		// Rest of code is former com_remository_startdown

		// +----------------------------------------------------------------------+
		// | PHP Version 4                                                        |
		// +----------------------------------------------------------------------+
		// | Copyright (c) 1997-2004 The PHP Group                                |
		// +----------------------------------------------------------------------+
		// | This source file is subject to version 3.0 of the PHP license,       |
		// | that is bundled with this package in the file LICENSE, and is        |
		// | available at through the world-wide-web at                           |
		// | http://www.php.net/license/3_0.txt.                                  |
		// | If you did not receive a copy of the PHP license and are unable to   |
		// | obtain it through the world-wide-web, please send a note to          |
		// | license@php.net so we can mail you a copy immediately.               |
		// +----------------------------------------------------------------------+
		// | Authors: David Irvine <dave@codexweb.co.za>                          |
		// |          Aidan Lister <aidan@php.net>                                |
		// +----------------------------------------------------------------------+
		//
		// $Id: com_remository_startdown.php,v 1.4 2006/03/13 10:16:52 buliang Exp $


		if (!defined('ENT_NOQUOTES')) {
		    define('ENT_NOQUOTES', 0);
		}

		if (!defined('ENT_COMPAT')) {
		    define('ENT_COMPAT', 2);
		}

		if (!defined('ENT_QUOTES')) {
		    define('ENT_QUOTES', 3);
		}


		/**
		 * Replace html_entity_decode()
		 *
		 * @category    PHP
		 * @package     PHP_Compat
		 * @link        http://php.net/function.html_entity_decode
		 * @author      David Irvine <dave@codexweb.co.za>
		 * @author      Aidan Lister <aidan@php.net>
		 * @version     $Revision: 1.4 $
		 * @since       PHP 4.3.0
		 * @internal    Setting the charset will not do anything
		 * @require     PHP 4.0.1 (trigger_error)
		 */
		if (!function_exists('html_entity_decode')) {
		    function html_entity_decode($string, $quote_style = ENT_COMPAT, $charset = null)
		    {
		        if (!is_int($quote_style)) {
		            trigger_error('html_entity_decode() expects parameter 2 to be long, ' . gettype($quote_style) . ' given', E_USER_WARNING);
		            return;
		        }

		        $trans_tbl = get_html_translation_table(HTML_ENTITIES);
		        $trans_tbl = array_flip($trans_tbl);

		        // Add single quote to translation table;
		        $trans_tbl['&#039;'] = '\'';

		        // Not translating double quotes
		        if ($quote_style & ENT_NOQUOTES) {
		            // Remove double quote from translation table
		            unset($trans_tbl['&quot;']);
		        }

		        return strtr($string, $trans_tbl);
		    }
		}
		// End of PHP group code for html_entity_decode

		$repository =& remositoryRepository::getInstance();
		$Small_Text_Len = $repository->Small_Text_Len;
		$Large_Text_Len = $repository->Large_Text_Len;
		$id = $this->idparm;
		$userid = $this->remUser->id;
		$fileinfo = $this->createFile();
		$nofile = $fileinfo->id ? false : true;
		if ($nofile AND $debugmissing) die('Could not create file object');
		$message = '';
		if (!$scribd AND $fileinfo->id AND $fileinfo->downloadForbidden($this->remUser, $message)) {
			die($message);
		}
		// Integration with AEC
		$aec_code = $interface->getCfg('absolute_path').'/components/com_acctexp/micro_integration/mi_remository.php';
		// Remove the 'false AND ' from the following line to make AEC download counts effective
		if (false AND !$scribd AND file_exists($aec_code)) {
			require_once($aec_code);
			$restrictionhandler = new remository_restriction( $database );
			$restrict_id = $restrictionhandler->getIDbyUserID( $this->remUser->id );
			$restrictionhandler->load( $restrict_id );
			if (!$restrictionhandler->hasDownloadsLeft()) $interface->redirect('index.php?option=com_remository', _DOWN_AEC_REFUSED);
			else $restrictionhandler->useDownload();
		}
		// End of AEC integration
		clearstatcache();
		$downpath = false;
		$len = 0;
		if ($fileinfo->islocal) {
			if ($fileinfo->filepath != '') {
				$downpath = $fileinfo->filePath();
				$downpath = html_entity_decode($downpath,ENT_QUOTES);
				if(!file_exists($downpath)) {
					$nofile = true;
					if ($debugmissing) die('File specified by path in files DB but does not exist');
				}
				else $len = filesize($downpath);
			}
			elseif ($fileinfo->plaintext) {
				$sql = "SELECT LENGTH(filetext) FROM #__downloads_text WHERE fileid=$id";
				$database->setQuery($sql);
				$len = $database->loadResult();
			}
			elseif ($fileinfo->isblob) {
				$sql = "SELECT SUM(bloblength) FROM #__downloads_blob WHERE fileid=$id GROUP BY fileid";
				$database->setQuery($sql);
				$len = $database->loadResult();
				//		echo 'Length of file from DB='.$len;
				//		$sql = "SELECT datachunk FROM #__downloads_blob WHERE fileid=$id AND chunkid=0";
				//		$database->setQuery($sql);
				//		$datachunk = $database->loadResult();
				//		echo 'Beginning of data from DB='.substr($datachunk,0,20);
			}
			else {
				$downpath = $repository->Down_Path.'/'.$fileinfo->realname;
				$downpath = html_entity_decode($downpath,ENT_QUOTES);
				if(!file_exists($downpath)) {
					$nofile = true;
					if ($debugmissing) die ('File specified by default path but does not exist');
				}
				else $len = filesize($downpath);
			}
			$displayname = $fileinfo->realname;
			//this fixes the single quotes (apostrophes)
			$displayname = html_entity_decode($displayname,ENT_QUOTES);
			$file_extension = remositoryAbstract::lastPart($displayname, '.');
		}
		if ($nofile) {
			echo _DOWN_FILE_NOTFOUND;
			$this->remositoryHome();
			exit;
		}
		while (@ob_end_clean());

		if (!$fileinfo->islocal) {
			$this->logDownload ($id, $userid, $len, $database, 0);
			$slimurl = trim($fileinfo->url);
			header("Location:$slimurl");
			exit;
		}

		$ctype = $this->setCtype($file_extension, $downpath);

		$offset = $origoffset = $this->rangeHandler($len);
		$this->writeHeaders($ctype, $displayname);
		$sent = 0;

		if ($fileinfo->plaintext) {
			$sql = "SELECT filetext FROM #__downloads_text WHERE fileid=$id";
			$database->setQuery($sql);
			$result = $database->loadObject($textobject);
			if (is_object($result)) $textobject = $result;
			echo substr($textobject->filetext, $offset);
			$sent += strlen($textobject->filetext) - $offset;
			flush();
		}
		elseif ($fileinfo->isblob) {
			$database->setQuery('SET NAMES utf8');
			$database->query();
			$database->setQuery('SET CHARACTER SET utf8');
			$database->query();
			$chunkid = 0;
			$datachunk = true;
			$sql = "SELECT chunkid, bloblength FROM #__downloads_blob WHERE fileid=$id ORDER BY chunkid";
			$database->setQuery($sql);
			$chunks = $database->loadObjectList();
			if ($chunks) foreach ($chunks as $chunk) {
				@set_time_limit(0);
				if ($offset >= $chunk->bloblength) {
					$offset -= $chunk->bloblength;
					continue;
				}
				$sql = "SELECT datachunk FROM #__downloads_blob WHERE fileid=$id AND chunkid=$chunk->chunkid";
				$database->setQuery($sql);
				$datachunk = $database->loadResult();
				echo $offset ? substr($datachunk, $offset) : $datachunk;
				$sent += ($offset ? strlen($datachunk) - $offset : strlen($datachunk));
				$offset = 0;
				flush();
				usleep(0.25*1000000);
			}
		}
		else {
			$fp = @fopen($downpath, "rb");
			$mqr = get_magic_quotes_runtime();
			set_magic_quotes_runtime(0);
			$chunksize = 1*(64*1024); // how many bytes per chunk
			if ($offset) fseek($fp, $offset);
			while($fp && !feof($fp)) {
				@set_time_limit(0);
				$data = fread($fp, $chunksize);
				print ($data);
				$sent += strlen($data);
				flush();
				if (!feof($fp)) usleep(0.25*1000000);
			}
			set_magic_quotes_runtime($mqr);
			fclose($fp);
		}
		$interface->triggerMambots('remositoryDoneDownload', array($fileinfo, $len, $this->remUser, $repository, $database));
		if (!$origoffset) $this->logDownload ($id, $userid, $len, $database, $sent);
		exit;
	}

	function logDownload ($id, $userid, $len, $database, $sent) {
		$sql = "UPDATE #__downloads_files SET downloads=downloads+1 WHERE id = $id";
		$database->setQuery( $sql );
		$database->query();
		$type = _LOG_DOWNLOAD;
		$ip = getenv('REMOTE_ADDR');
		$timestamp = date('Y-m-d H:i:s');
		$sql = "INSERT INTO #__downloads_log (type, date, userid, fileid, value, ipaddress) VALUES ($type, '$timestamp', '$userid', $id, '$sent', '$ip')";
		$database->setQuery($sql);
		$database->query();
	}

	function setCtype ($file_extension, $downpath) {
		//This will set the Content-Type to the appropriate setting for the file
		switch( $file_extension ) {
			 case "pdf": $ctype="application/pdf"; break;
		     case "exe": $ctype="application/octet-stream"; break;
		     case "zip": $ctype="application/zip"; break;
		     case "doc": $ctype="application/msword"; break;
		     case "xls": $ctype="application/vnd.ms-excel"; break;
		     case "ppt": $ctype="application/vnd.ms-powerpoint"; break;
		     case "gif": $ctype="image/gif"; break;
		     case "png": $ctype="image/png"; break;
		     case "jpeg":
		     case "jpg": $ctype="image/jpg"; break;
		     case "mp3": $ctype="audio/mpeg"; break;
		     case "wav": $ctype="audio/x-wav"; break;
		     case "mpeg":
		     case "mpg":
		     case "mpe": $ctype="video/mpeg"; break;
		     case "mov": $ctype="video/quicktime"; break;
		     case "avi": $ctype="video/x-msvideo"; break;

		     //The following are for extensions that shouldn't be downloaded (sensitive stuff, like php files)
		     case "php":
		     case "htm":
		     case "html": if ($downpath) die("<b>Cannot be used for ". $file_extension ." files!</b>");

		     default: $ctype="application/force-download";
		}
		return $ctype;
	}

	function writeHeaders ($ctype, $displayname) {
		//Begin writing headers
		header("Cache-Control: max-age=60");
		header("Cache-Control: private");
		header("Content-Description: File Transfer");

		//Use the switch-generated Content-Type
		header("Content-Type: $ctype");

		//Force the download
		header("Content-Disposition: attachment; filename=\"$displayname\"");
		header("Content-Transfer-Encoding: binary");
		// if ($len) header("Content-Length: ".$len);
	}
	
	function rangeHandler ($size) {
		if (!empty($_SERVER['HTTP_RANGE'])) {
			$regex = '/^bytes=([0-9]*)\-([0-9]*)/';
			preg_match($regex, $_SERVER['HTTP_RANGE'], $matches);
		}
		$seek_end = (empty($matches[2])) ? ($size - 1) : min((integer) $matches[2] ,($size - 1));
		$seek_start = (empty($matches[1]) OR $seek_end < (integer) $matches[1]) ? 0 : max((integer) $matches[1],0);
		$partial = ($seek_start > 0 OR $seek_end < ($size - 1));
		if ($partial) header('HTTP/1.1 206 Partial Content');
		header('Accept-Ranges: bytes');
		if ($partial) header("Content-Range: bytes $seek_start-$seek_end/$size");
		header('Content-Length: '.($seek_end - $seek_start + 1));
		return $seek_start;
	}

}
