<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remository_fileinfo_Controller extends remositoryUserControllers {

	function fileinfo ($func) {
		if ('directinfo' == $func) $func = 'showdown';
		$directlink = false;
		$interface =& remositoryInterface::getInstance();
		switch ($func) {
			case 'fileinfo':
			$autodown = 0;
			break;
			case 'startdown':
			$autodown = 1;
		    break;
			case 'showdown':
			$autodown = 2;
		    break;
			case 'finishdown':
			$autodown = 1;
		}
	    $file = $this->createFile ();
	    if ($file->downloadForbidden($this->remUser, $message) AND !$this->repository->See_Files_no_download) {
	    	echo $message;
	    	return;
	    }
	    if ((($file->licenseagree AND $file->license) OR $this->repository->Default_Licence) AND ($func == 'startdown' OR ($func == 'finishdown' AND remositoryRepository::getParam($_POST, 'agreecheck', 'off') != 'on'))) {
	    	require_once ($this->admin->v_classes_path.'remositoryDownloadAgreeHTML.php');
	    	$view =& new remositoryDownloadAgreeHTML($this);
	    	$view->downloadAgreeHTML($file);
			return;
		}
		if ($func == 'finishdown' AND $this->repository->wrongCheck($_POST['da'],$this->idparm,'finishdown')){
			echo _DOWN_LEECH_WARN;
			?>
			<br>&nbsp;<br><a href="../../index.php?option=com_remository&Itemid=<?php echo $this->Itemid;?>"><img src="<?php echo $interface->getCfg('live_site');?>/components/com_remository/images/gohome.gif" width="32" height="32" border="0" align="absmiddle"> <?php echo _MAIN_DOWNLOADS; ?></a>
			<?php
			exit;
		}
		if ($file->windowtitle) $interface->SetPageTitle($file->windowtitle);
		else $interface->SetPageTitle($file->filetitle);
		if (remositoryRepository::getParam($_POST,'submit_vote','')) {
			$user_rating = remositoryRepository::getParam($_POST,'user_rating',0);
			if (($user_rating>=1) AND ($user_rating<=5)) {
				if (!$file->userVoted($this->remUser)) $file->addVote($this->remUser, $user_rating);
			}
		}
		if (remositoryRepository::getParam($_POST,'submit_comm','')) {
			if (!$file->userCommented($this->remUser)) {
				$thecomment =& new remositoryComment($this->remUser->id,$this->remUser->fullname,$this->remUser->name,'Review Title',remositoryRepository::getParam($_POST,'comment',''));
				$thecomment->saveComment($file);
			}
		}
		if ($this->repository->Scribd AND in_array($file->filetype,explode(',', $this->repository->ExtsDisplay))) {
			$displaynow = remositoryRepository::getParam($_REQUEST, 'displaynow', 2);
		}
		else $displaynow = 0;	
		$database = $interface->getDB();
		$database->setQuery("SELECT id FROM #__downloads_files WHERE submitdate > '$file->submitdate' OR ('$file->submitdate' = submitdate AND id < $file->id) ORDER BY submitdate DESC, id DESC LIMIT 1");
		$next = $database->loadResult();
		$database->setQuery("SELECT id FROM #__downloads_files WHERE submitdate < '$file->submitdate' OR ('$file->submitdate' = submitdate AND id > $file->id) ORDER BY submitdate DESC, id LIMIT 1");
		$previous = $database->loadResult();
		require_once ($this->admin->v_classes_path.'remositoryFileInfoHTML.php');
		$view =& new remositoryFileInfoHTML($this);
		$view->fileinfoHTML($file, $autodown, $displaynow, $next, $previous);
		// Uncomment the next two lines if using JomComment in Joomla 1.5
		// require_once($interface->getCfg('absolute_path').'/plugins/content/jom_comment_bot.php');
		// echo jomcomment($file->id, "com_remository");
	}

}
