<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remository_savefile_Controller extends remositoryUserControllers {

	function savefile ($func) {
		//Process the variables
		$oldid = intval($_POST['oldid']);
		$container =& new remositoryContainer(intval($_POST['containerid']));
		$this->remUser->allowUploadCheck($container);
		if ($this->remUser->hasAutoApprove($container)) {
		    $newfile =& new remositoryFile();
		    if ($oldid) {
				$newfile->id = $oldid;
				$newfile->getValues($this->remUser);
				if (!$newfile->updatePermitted($this->remUser)) {
					$this->error_popup (_DOWN_NOT_AUTH);
					return;
				}
				$oldphysical =& $newfile->obtainPhysical();
				$oldcontainer = $newfile->containerid;
			}
		    $newfile->published = '1';
		}
		else {
			$newfile =& new remositoryTempFile();
			if ($oldid) {
				$oldfile =& new remositoryFile();
				$oldfile->id = $oldid;
				$oldfile->getValues($this->remUser);
				$oldcontainer = $oldfile->containerid;
				if (!$oldfile->updatePermitted($this->remUser)) {
					$this->error_popup (_DOWN_NOT_AUTH);
					return;
				}
				$newfile->setValues($oldfile);
				$newfile->isblob = $newfile->plaintext = $newfile->published = 0;
			}
		}
		$newfile->addPostData();
		$newfile->validate(false);
		$newfile->memoContainer($container);
		if (!$newfile->submittedby OR !$this->remUser->isAdmin()) $newfile->submittedby = $this->remUser->id;
		if (eregi(_REMOSITORY_REGEXP_URL,$newfile->url) OR eregi(_REMOSITORY_REGEXP_IP,$newfile->url)) {
		  	if ($newfile->filetitle == '') $newfile->filetitle = $newfile->lastPart($newfile->url,'/');
		  	$newfile->metatype = 1;
			$newfile->saveFile();
			$upload = null;
			$logentry =& new remositoryLogEntry(_LOG_UPLOAD, $this->remUser->id, $newfile->id, 0);
			$logentry->insertEntry();
		}
		else {
			$upload =& new remositoryPhysicalFile();
			$upload->handleUpload();
			if ($oldid AND $upload->error_message == _ERR1) {
				// If true, must be auto-approve
				if (isset($oldphysical)) {
					if (!$oldphysical->moveTo($newfile->filepath.$newfile->realname, $newfile->id, $newfile->isblob, $newfile->plaintext, true)) $this->error_popup(_DOWN_MOVE_FILE_FAILED);
					$newfile->realwithid = 1;
				}
				$newfile->metatype = 2;
				$newfile->saveFile();
				$upload = null;
			}
			// In this case, a file should have been received - error condition
			elseif ($upload->error_message) {
				$this->error_popup($upload->error_message);
				$upload = null;
			}
			// This is the case of having a new file upload
			else {
				if (is_a($newfile,'remositoryTempFile')) $newfile->metatype = 1;
				if (isset($oldphysical)) $oldphysical->delete();
				if ($newfile->storePhysicalFile($upload) AND $newfile->published) {
					$logentry =& new remositoryLogEntry(_LOG_UPLOAD, $this->remUser->id, $newfile->id, $newfile->filesize);
					$logentry->insertEntry();
				}
				$physical = $newfile->obtainPhysical();
				$this->savethumb($newfile, $physical);
			}
		}
		$this->repository->resetCounts(array());
		$thumbs =& new remositoryThumbnails($newfile);
		if ($thumbs->freecount) {
			for ($i = 1; $i <= $thumbs->freecount; $i++) {
				if (!empty($_FILES['userfile'.(string)$i]['tmp_name'])) {
					$thumbnail = new remositoryPhysicalFile();
					$thumbnail->handleUpload((string) $i);
					$thumbs->addImage($thumbnail, $newfile->id);
				}
			}
		}


		//Send Admin notice
		if ($this->repository->Send_Sub_Mail) $this->repository->sendAdminMail($this->remUser->fullname.' ('.$this->remUser->name.')', $newfile->filetitle, $newfile->containerid, $newfile->published);
		require_once ($this->admin->v_classes_path.'remositoryAddFileDoneHTML.php');
		$view =& new remositoryAddFileDoneHTML($this);
		$view->addFileDoneHTML ($newfile);
	}

	function savethumb ($file, $upload) {
		$graphics = array('png','gif','jpg');
		$repository =& remositoryRepository::getInstance();
		if ($repository->Make_Auto_Thumbnail AND in_array($file->filetype, $graphics)) {
			$thumbnails =& new remositoryThumbnails($file);
			if ($thumbnails->freecount) {
				$thumbnails->addImage($upload, $file->id, '', true);
			}
		}
	}
}
