<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remository_search_Controller extends remositoryUserControllers {
	// For each item, make an entry with name used in HTML pointing to field name in file table
	var $searchable = array (
	'search_filetitle' => 'filetitle',
	'search_filedesc' => 'description'
 	);

	function search ($func)
	{
		$interface =& remositoryInterface::getInstance();
		$interface->SetPageTitle('Search for files');
		if (remositoryRepository::getParam($_REQUEST,'submit')) {
			$search_text = remositoryRepository::getParam($_REQUEST,'search_text','');
			$search_text = $interface->getEscaped($search_text);
			$seek_fields = array();
			$querystring = "&func=search&submit=yes";
			foreach ($this->searchable as $HTMLname=>$fieldname) {
				$value = remositoryRepository::getParam($_REQUEST, $HTMLname, 0);
				if ($value) {
					$seek_fields[] = $fieldname;
					$querystring .= "&$HTMLname=".(string) $value;
				}
			}
			if ($search_text) {
				$total = $this->repository->searchRepository($search_text, $seek_fields, $this->remUser, null, true);
				$page = remositoryRepository::getParam($_REQUEST, 'page', 1);
				$querystring .= '&search_text='.$search_text;
				$pagecontrol =& new remositoryPage ( $total, $this->remUser, _ITEMS_PER_PAGE, $page, $querystring );
				$file_array = $this->repository->searchRepository($search_text, $seek_fields, $this->remUser, $pagecontrol);
			}
			else {
				$file_array = array();
				$pagecontrol = null;
			}
			require_once ($this->admin->v_classes_path.'remositorySearchResultsHTML.php');
			$view =& new remositorySearchResultsHTML($this);
			$view->searchResultsHTML($file_array, $search_text, $pagecontrol);
	  	}
		else {
			require_once ($this->admin->v_classes_path.'remositorySearchBoxHTML.php');
			$view =& new remositorySearchBoxHTML($this);
			$view->searchBoxHTML();
		}
	}
}

?>