<?php
/**
 * @version $Id: mi_mysql_query.php 16 2007-07-02 13:29:29Z mic $
 * @package AEC - Account Control Expiration - Subscription component for Joomla! OS CMS
 * @subpackage Micro Integrations - MySQL Query
 * @copyright 2006/2007 Copyright (C) David Deutsch
 * @author David Deutsch <skore@skore.de> & Team AEC - http://www.globalnerd.org
 * @license GNU/GPL v.2 http://www.gnu.org/copyleft/gpl.html
 */

/***
 * This version copyright (c) 2008 by Martin Brampton
 * martin@remository.com
 * http://www.remository.com
 * Modified to correctly integrate with Remository
 */

defined( '_VALID_MOS' ) OR defined('_JEXEC') OR die( 'Direct Access to this location is not allowed.' );


class mi_remository
{
	var $settings = array();
	var $absolute_path = '';
	var $authoriser = null;
	var $database = null;
	var $dbprefix = '';
	
	// This needs review for compatibility with Joomla 1.5 native or Aliro
	// Other methods should be safe
	function mi_remository () {
		global $mainframe, $mosConfig_dbprefix;
		$this->dbprefix = $mosConfig_dbprefix;
		require_once($mainframe->getCfg('absolute_path').'/components/com_remository/remository.interface.php');
		$interface =& remositoryInterface::getInstance();
		$this->absolute_path = $interface->getCfg('absolute_path');
		require_once($this->absolute_path.'/components/com_remository/remository.class.php');
		require_once($this->absolute_path.'/components/com_remository/p-classes/remositoryAuthoriser.php');
		$lang = $interface->getCfg('lang');
		$langdir = $this->absolute_path.'/components/com_remository/language/';
		$mosConfig_sitename = $mainframe->getCfg('sitename');
		$Small_Text_Len = $Large_Text_Len = 100;
		if (file_exists($langdir.$lang.'.php')) require_once($langdir.$lang.'.php');
		require_once($langdir.'english.php');
		$this->authoriser =& aliroAuthorisationAdmin::getInstance();
		$this->database = $interface->getDB();
	}
	
	function Info()
	{
		$info['name'] = _AEC_MI_NAME_REMOS;
		$info['desc'] = _AEC_MI_DESC_REMOS;

		return $info;
	}

	function checkInstallation()
	{
		$tables	= $this->database->getTableList();
		return is_array($tables) AND in_array( $this->dbprefix . 'acctexp_mi_remository', $tables );
	}

	function install()
	{
		$query = 'CREATE TABLE IF NOT EXISTS `#__acctexp_mi_remository` ('
		. '`id` int(11) NOT NULL auto_increment,'
		. '`userid` int(11) NOT NULL,'
		. '`active` int(4) NOT NULL default \'1\','
		. '`granted_downloads` int(11) NULL,'
		. '`unlimited_downloads` int(3) NULL,'
		. '`used_downloads` int(11) NULL,'
		. '`params` text NULL,'
		. ' PRIMARY KEY (`id`)'
		. ')'
		;
		$this->database->setQuery( $query );
		$this->database->query();
	}

	function Settings ()
	{
		foreach ($this->authoriser->getAllRoles() as $role) {
			$sg[] = mosHTML::makeOption( $role, $role);
		}

		$del_opts[0] = mosHTML::makeOption ( "No", "Just apply group(s) below." ); // Should probably be langauge file defined?
		$del_opts[1] = mosHTML::makeOption ( "All", "Delete ALL, then apply group(s) below." );
		$del_opts[2] = mosHTML::makeOption ( "Set", "Delete Group Set on Application, then apply group(s) below." );

		$settings['add_downloads'] = array( 'inputA' );
		$settings['set_downloads'] = array( 'inputA' );
		$settings['set_unlimited'] = array( 'list_yesno' );

		$current_groups = explode(';', $this->settings['group']);
		$settings['lists']['group']	= mosHTML::selectList($sg, 'group[]', 'size="4" multiple="multiple"', 'value', 'text', $current_groups);
		$current_groups_exp = explode(';', $this->settings['group_exp']);
		$settings['lists']['group_exp']	= mosHTML::selectList($sg, 'group_exp[]', 'size="4" multiple="multiple"', 'value', 'text', $current_groups_exp);

		$settings['set_group'] = array( 'list_yesno' );
		$settings['group'] = array( 'list' );
		$settings['lists']['delete_on_exp'] = mosHTML::selectList( $del_opts, 'delete_on_exp', 'size="3"', 'value', 'text', $this->settings['delete_on_exp'] );
		$settings['delete_on_exp'] = array( 'list' );
		$settings['set_group_exp'] = array( 'list_yesno' );
		$settings['group_exp'] = array( 'list' );

		return $settings;
	}

	function saveparams( $params )
	{
		$params['group'] = implode(';', $params['group']);
		$params['group_exp'] = implode(';', $params['group_exp']);
		return $params;
	}

	function detect_application()
	{
		return is_dir( $this->absolute_path . '/components/com_remository/c-classes' );
	}

	function hacks()
	{
		return array();
	}

	function expiration_action( $request )
	{
		$metaUser = $request->metaUser;

		if ( 'Set' == $this->settings['delete_on_exp'] ) {
			$roles = explode(';', $this->settings['group']);
			foreach ($roles as $role) $this->authoriser->unassign($role, 'aUser', $metaUser->userid);
		}

		if ( 'All' == $this->settings['delete_on_exp'] ) {
			$this->authoriser->dropAccess('aUser', $metaUser->userid);
		}

		if ($this->settings['set_group_exp']) {
			$roles = explode(';', $this->settings['group_exp']);
			foreach ($roles as $role) $this->authoriser->assign($role, 'aUser', $metaUser->userid);
		}

		$mi_remositoryhandler = new remository_restriction( $this->database );
		$mi_id = $mi_remositoryhandler->getIDbyUserID( $metaUser->userid );
		$mi_remositoryhandler->load( $mi_id );

		if ( $mi_id ) $mi_remositoryhandler->deactivateAndStore();

		return true;
	}

	function action( $request )
	{
		$metaUser = $request->metaUser;
		if ( $this->settings['set_group'] ) {
			$roles = explode(';', $this->settings['group']);
			foreach ($roles as $role) $this->authoriser->assign($role, 'aUser', $metaUser->userid);
		}

		$mi_remositoryhandler = new remository_restriction( $this->database );
		$mi_id = $mi_remositoryhandler->getIDbyUserID( $metaUser->userid );
		$mi_remositoryhandler->load( $mi_id );

		if ( !$mi_id ) $mi_remositoryhandler->activate();

		if ( $this->settings['set_downloads'] ) {
			$mi_remositoryhandler->setDownloads( $this->settings['set_downloads'] );
		} elseif ( $this->settings['add_downloads'] ) {
			$mi_remositoryhandler->addDownloads( $this->settings['add_downloads'] );
		}

		$mi_remositoryhandler->checkAndStore();

		return true;
	}
}

class remository_restriction extends mosDBTable {
	/** @var int Primary key */
	var $id					= null;
	/** @var int */
	var $userid 			= null;
	/** @var int */
	var $active				= null;
	/** @var int */
	var $granted_downloads	= null;
	/** @var int */
	var $unlimited_downloads	= null;
	/** @var text */
	var $used_downloads		= null;
	/** @var text */
	var $params				= null;

	// Constructor
	function remository_restriction( &$db )
	{
		$this->mosDBTable( '#__acctexp_mi_remository', 'id', $db );
	}

	function getIDbyUserID( $userid )
	{
		$userid = intval($userid);
		$query = "SELECT `id` FROM #__acctexp_mi_remository WHERE `userid` = $userid";
		$this->database->setQuery( $query );
		$result = $this->database->loadResult();
		return $result ? $result : 0;
	}


	function is_active()
	{
		return $this->active ? true : false;
	}

	function getDownloadsLeft()
	{
		return empty( $this->unlimited_downloads ) ? ($this->granted_downloads - $this->used_downloads) : 9999;
	}

	function hasDownloadsLeft()
	{
		return $this->getDownloadsLeft() > 0 ? true : false;
	}

	function useDownload()
	{
		return ( $this->is_active() AND $this->hasDownloadsLeft() ) ? ($this->incrementDownloadStore() OR true) : false;
	}
	
	function activate ($userid) {
		$this->userid = $userid;
		$this->active = 1;
	}
	
	function deactivateAndStore () {
		$this->active = 0;
		$this->checkAndStore();
	}
	
	function incrementDownloadStore () {
		$this->used_downloads++;
		$this->checkAndStore();
	}
	
	function checkAndStore () {
		$this->check();
		$this->store();
	}

	function setDownloads( $set )
	{
		$this->granted_downloads = $set;
	}

	function addDownloads( $add )
	{
		$this->granted_downloads += $add;
	}
}