<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remositoryComment extends remositoryAbstract {

	var $component='com_remository';
	var $id=0;
	var $itemid=0;
	var $userid=0;
	var $name='';
	var $username='';
	var $userURL='';
	var $title='';
	var $comment='';
	var $fullreview='';
	var $date=null;

	function remositoryComment ($userid, $name, $username, $title, $comment, $date=null, $id=0) {
		$this->userid = $userid;
		$this->name = $name;
		$this->username = $username;
		$this->title = $title;
		$this->comment = strip_tags($comment);
		$this->date = $date;
		$this->id = $id;
	}

	function saveComment (&$file) {
		$interface =& remositoryInterface::getInstance();
		if ($this->date == null) $this->date = date('Y-m-d H:i:s');
		$comment = $interface->getEscaped($this->comment);
		$title = $interface->getEscaped($this->title);
		$sql="INSERT INTO #__downloads_reviews (component, itemid, userid, title, comment, date) VALUES ('$this->component', $file->id, $this->userid, '$title', '$comment', '$this->date')";
		remositoryRepository::doSQL($sql);
	}

	function &getComments (&$file) {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$sql = "SELECT c.id, c.title, c.comment, c.date, u.id as userid, u.name, u.username FROM #__downloads_reviews AS c INNER JOIN #__users AS u ON c.userid=u.id WHERE c.itemid=$file->id";
		$database->setQuery($sql);
		$rows = $database->loadObjectList();
		$comments = array();
		if ($rows) {
			foreach ($rows as $row) {
				$comments[] =& new remositoryComment ($row->userid, $row->name, $row->username, $row->title, $row->comment, $row->date, $row->id);
			}
		}
		return $comments;
	}

	function deleteComments ($fileid) {
		$sql = "DELETE FROM #__downloads_reviews WHERE component='com_remository' AND itemid=$fileid";
		remositoryRepository::doSQL($sql);
	}

	function updateComment ($commentid, $newtext) {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$newtext = strip_tags($newtext);
		$newtext = $database->getEscaped($newtext);
		$sql = "UPDATE #__downloads_reviews SET comment = '$newtext' WHERE id = $commentid";
		remositoryRepository::doSQL($sql);
	}

	function deleteComment ($commentid) {
		$sql = "DELETE FROM #__downloads_reviews WHERE component='com_remository' AND id=$commentid";
		remositoryRepository::doSQL($sql);
	}

}

?>