<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remositoryContainer extends remositoryAbstract {
	/** @var int ID for container record in database */
	var $id=0;
	/** @var int ID of parent container in database if a folder */
	var $parentid=0;
	/** @var string Name of container */
	var $name='';
	/** @var string Alias for container name - used in SEF */
	var $alias='';
	/** @var string Path for storing files */
	var $filepath='';
	/** @var string Container description */
	var $description='';
	/** @var bool Is the container published? */
	var $published=false;
	/** @var int Count of contained folders */
	var $foldercount=0;
	/** @var int Files in the container count */
	var $filecount=0;
	/** @var string Icon - not sure how this is used */
	var $icon='';
	/** @var Visitor options 1=upload, 2=download, 3=both, 0=neither */
	var $registered='2';
	/** @var User options 1=upload, 2=download, 3=both, 0=neither */
	var $userupload='3';
	/** @var bool Is the file to be stored as a text string? */
	var $plaintext=0;
	/** @var int Group of users that has access to this container */
	var $groupid=0;
	/** @var int Editor group of users */
	var $editgroup=0;
	/** @var bool Auto-approve for Admin - Yes or No (Global applies) */
	var $adminauto=0;
	/** @var bool Auto-approve for user - Yes or No (Global applies)*/
	var $userauto=0;
	/** @var int Auto-approve group of users */
	var $autogroup=0;

	/**
	* File object constructor
	* @param int Container ID from database or null
	*/
	function remositoryContainer ( $id=0 ) {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$this->id = $id;
		if ($id) {
			$sql = "SELECT * FROM #__downloads_containers WHERE id = $this->id";
			$this->readDataBase( $sql );
		}
	}

	function tableName () {
		return '#__downloads_containers';
	}

	function delete () {
		$manager =& remositoryContainerManager::getInstance();
		$manager->delete($this->id);
	}

	function deleteAll () {
		$folders = $this->getChildren(false);
		foreach ($folders as $folder) $folder->deleteAll ();
		$files = $this->getFiles(true);
		foreach ($files as $file) $file->deleteFile();
		$tempfiles = $this->getTempFiles();
		foreach ($tempfiles as $file) $file->deleteFile();
		$this->delete();
	}

	function saveValues () {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$this->forceBools();
		if ($this->id == 0) {
			$sql = $this->insertSQL();
			remositoryRepository::doSQL ($sql);
			$this->id = $database->insertid();
		}
		else {
			$sql = $this->updateSQL();
			remositoryRepository::doSQL ($sql);
		}
	}

	function setMetaData () {
		$interface =& remositoryInterface::getInstance();
		$interface->prependMetaTag('description', strip_tags($this->name));
		if ($this->keywords) $interface->prependMetaTag('keywords', $this->keywords);
		else $interface->prependMetaTag('keywords', $this->name);
	}

	function isCategory () {
		if ($this->parentid == 0) return true;
		else return false;
	}

	function getCategoryName ($showself=false) {
		$category = $this->getCategory();
		if ($this->parentid OR $showself) return $category->name;
		return '*';
    }

    function &getCategory () {
		$container =& $this;
		while (is_object($container)) {
			$category = $container;
			$container =& $category->getParent();
		}
		return $category;
	}

    function getFamilyNames ($include=false) {
    	$names = '';
    	$parent = $this->getParent();
    	if ($parent AND $parent->parentid) {
    		$names .= '/'.$parent->name;
    		$grandparent = $parent->getParent();
    		if ($grandparent AND $grandparent->parentid) {
    			$names = '/'.$grandparent->name.$names;
				$greatgrandparent = $grandparent->getParent();
				if ($greatgrandparent->parentid) $names = '..'.$names;
			}
    	}
    	if ($include AND $this->id AND $this->parentid) $names = $names.'/'.$this->name;
    	if ($names) return $names;
    	return '-';
    }

	function downloadForbidden (&$user) {
		$authoriser =& aliroAuthoriser::getInstance();
		if ($authoriser->checkPermission ('aUser', $user->id, 'download', 'remosFolder', $this->id)
		OR $authoriser->checkPermission ('aUser', $user->id, 'edit', 'remosFolder', $this->id)
		) return false;
		if ($user->isLogged()) {
			echo '<br/>$nbsp<br/> '._DOWN_MEMBER_ONLY_WARN.$this->name;
			return true;
		}
		echo '<br/>&nbsp;<br/> '._DOWN_REG_ONLY_WARN;
		return true;
	}

	function &getChildren ($published=true, $search='') {
		$manager =& remositoryContainerManager::getInstance();
		$children =& $manager->getChildren($this->id, $published, $search);
		return $children;
	}

	function descendantSQL ($operation, $actions='') {
	    return "$operation #__downloads_containers AS c, #__downloads_structure AS s $actions WHERE s.item=c.id AND s.container=$this->id AND s.item!=s.container";
	}

	function getDescendants ($search='') {
		$manager =& remositoryContainerManager::getInstance();
		if ($this->id) {
			$ids =& $this->getDescendantIDs ($search);
			return $manager->getFromIDs($ids);
		}
		else return $manager->getFolders($search);
	}

	// Gives a null result if the container is not populated
	function &getDescendantIDs ($search='') {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$result = array();
		if ($this->id) {
			$search = $interface->getEscaped($search);
			$sql = $this->descendantSQL('SELECT c.id FROM');
			if ($search) $sql .= " AND LOWER(name) LIKE '%$search%'";
			$sql .= ' ORDER BY name';
			$database->setQuery($sql);
			$result = $database->loadResultArray();
		}
		return $result;
	}

	function makeDescendantsInherit () {
	    $fields = $this->inheritableFields();
	    foreach ($fields as $field) {
	    	$value = $this->$field;
	        $update[] = "c.$field='$value'";
		}
		$setter = 'SET '.implode(', ',$update);
	    $sql = $this->descendantSQL('UPDATE', $setter);
	    remositoryRepository::doSQL($sql);
	}

	function moveFilesAsNecessary ($inherit=false) {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		if ($inherit) {
			$containerids =& $this->getDescendantIDs();
			array_push($containerids, $this->id);
		}
		else $containerids = array($this->id);
		$selector = implode(',', $containerids);
		if (!$this->filepath AND !$this->plaintext) $isblob = 1;
		else $isblob = 0;
		$sql = "SELECT id, filepath, realname, isblob, plaintext, realwithid FROM #__downloads_files "
		." WHERE containerid IN($selector) AND (filepath != '$this->filepath' OR isblob != $isblob OR plaintext != $this->plaintext)";
		$database->setQuery($sql);
		$files = $database->loadObjectList();
		$physical =& new remositoryPhysicalFile();
		if ($files) foreach ($files as $file) {
			$physical->setData($file->filepath.$file->realname, $file->id, $file->isblob, $file->plaintext, $file->realwithid);
			if ($physical->moveTo($this->filepath.$file->realname, $file->id, $isblob, $this->plaintext, true)) {
				$database->setQuery("UPDATE #__downloads_files "
				." SET filepath='$this->filepath', isblob=$isblob, plaintext=$this->plaintext, realwithid=1"
				." WHERE id = $file->id");
				$database->query();
			}
			else echo 'move failed';
		}
	}

	function inheritableFields () {
		return array ('registered','userupload','filepath','groupid','plaintext','editgroup','adminauto','userauto','autogroup');
	}

	function memoContainer (&$container) {
	    $fields = $this->inheritableFields();
	    foreach ($fields as $field) {
	        $this->$field = $container->$field;
	    }
	 }

	function isDownloadable (&$user) {
		$authoriser =& aliroAuthoriser::getInstance();
		return ($authoriser->checkPermission ('aUser', $user->id, 'download', 'remosFolder', $this->id)
		OR $authoriser->checkPermission ('aUser', $user->id, 'edit', 'remosFolder', $this->id)
		);
	}

	function &getVisibleChildren (&$user) {
		$manager =& remositoryContainerManager::getInstance();
		$children = $manager->getVisibleChildren ($this->id, $user);
		return $children;
	}

	function checkFilePath () {
		if ($this->plaintext) $this->filepath = '';
		else {
			$this->filepath=trim(str_replace("\\","/",$this->filepath));
			if (!$this->filepath) {
				$repository =& remositoryRepository::getInstance();
				if (!$repository->Use_Database) $this->filepath = $repository->Down_Path;
			}
			if ($this->filepath) {
				$dir =& new remositoryDirectory($this->filepath, true);
				$this->filepath = $dir->path;
			}
		}
	}

	function &getParent () {
		$manager =& remositoryContainerManager::getInstance();
		$parent =& $manager->getParent($this->parentid);
		return $parent;
	}

	function increment ($by='0') {
		$parent = $this->getParent();
		if ($parent != null) $parent->increment($by);
		$this->filecount = $this->filecount+$by;
		$sql="UPDATE #__downloads_containers SET filecount=$this->filecount WHERE id=$this->id";
		remositoryRepository::doSQL($sql);
	}

	function areFilesVisible (&$user) {
		$repository =& remositoryRepository::getInstance();
		if ($repository->See_Files_no_download OR $user->isAdmin()) return true;
		return $this->isDownloadable($user);
	}


	function getFiles ($published, $orderby=_REM_DEFAULT_ORDERING, $search='', $limitstart=0, $limit=0, $descendants=false) {
		$sql = remositoryFile::getFilesSQL($published, false, $this->id, $descendants, $orderby, $search, $limitstart, $limit);
		return remositoryRepository::doSQLget($sql, 'remositoryFile');
	}

	function getFilesCount ($search='', $remUser, $descendants=false) {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		if ($remUser->isAdmin()) $published = false;
		else $published = true;
		$sql = remositoryFile::getFilesSQL($published, true, $this->id, $descendants, 2, $search);
		$database->setQuery( $sql );
		return $database->loadResult();
	}

	function setFileCount ($chain=null) {
		$this->filecount = 0;
		$this->foldercount = 0;
		if (is_array($chain)) {
			$sql = "DELETE FROM #__downloads_structure WHERE item=$this->id";
			remositoryRepository::doSQL($sql);
			$chain[] = $this->id;
			foreach ($chain as $containerid) {
				$sql = "INSERT INTO #__downloads_structure (container, item) VALUES ($containerid, $this->id)";
				remositoryRepository::doSQL($sql);
			}
		}
		$children = $this->getChildren(false);
		foreach ($children as $child) {
			$counts = $child->setFileCount($chain);
			$this->filecount = $this->filecount + $counts[0];
			$this->foldercount = $this->foldercount + $counts[1];
		}
		$this->filecount = $this->filecount + remositoryFile::getCountInContainer($this->id,true);
		$this->foldercount = $this->foldercount + count($children);
		$sql="UPDATE #__downloads_containers SET filecount=$this->filecount, foldercount=$this->foldercount WHERE id=$this->id";
		remositoryRepository::doSQL($sql);
		return array($this->filecount,$this->foldercount);
	}

	function getTempFiles ($search='') {
		$interface =& remositoryInterface::getInstance();
		if ($this->id == 0) return array();
		$sql = "SELECT * FROM #__downloads_files WHERE containerid = $this->id AND metatype > 0";
		if ($search) {
			$search = $interface->getEscaped($search);
			$sql .= " AND LOWER(filetitle) LIKE '%$search%'";
		}
		$results = remositoryRepository::doSQLget($sql,'remositoryTempFile');
		foreach ($results as $key=>$result) $results[$key]->containerid = -$result->containerid;
		return $results;
	}

	// This is used admin side, and wants all containers, whether they can accept files or not
	function getSelectList ($type, $parm, &$user, $notThis=0) {
		$repository =& remositoryRepository::getInstance();
		if ($this->id) $selector[] = $repository->makeOption(0,_DOWN_NO_PARENT);
		else $selector = array();
		$this->addSelectList('',$selector,$notThis,$user);
		return $repository->selectList( $selector, $type, $parm, $this->id );
	}

	// This is used on user side for uploads, only want containers that can accept files
	function getPartialSelectList ($type, $parm, &$user, $notThis=0) {
		$repository =& remositoryRepository::getInstance();
		$selector = array();
		$this->addSelectList('', $selector, $notThis, $user, true);
		return (count($selector) ? $repository->selectList( $selector, $type, $parm, $this->id ) : '');
	}

	function addSelectList ($prefix, &$selector, $notThis, &$user, $usable=false) {
		if ($notThis AND $this->id == $notThis) return;
		$repository =& remositoryRepository::getInstance();
		$addthis = false;
		if ($user->isAdmin()) {
			$published = false;
			$addthis = true;
		}
		else {
			$published = true;
			$authoriser =& aliroAuthoriser::getInstance();
			if ($authoriser->checkPermission ('aUser', $user->id, 'upload', 'remosFolder', $this->id)
			OR $authoriser->checkPermission ('aUser', $user->id, 'edit', 'remosFolder', $this->id)
			) $addthis = true;
		}
		if ($usable AND $this->filepath AND (!file_exists($this->filepath) OR !is_writeable($this->filepath))) $addthis = false;
		if ($addthis AND (($notThis == 0) OR ($this->id != $notThis))) {
			$name = $this->id ? $this->name : _DOWN_NO_PARENT;
			$selector[] = $repository->makeOption($this->id, $prefix.htmlspecialchars($name));
		}
		foreach ($this->getChildren($published) as $container) $container->addSelectList($prefix.$this->name.'/',$selector,$notThis,$user);
	}

	function getURL () {
		$func = remositoryRepository::getParam ($_REQUEST, 'func');
		$type = 'direct' == substr($func,0,6) ? 'directlist' : 'select';
		return remositoryRepository::remositoryFunctionURL($type, $this->id);
	}

	function showPathway () {
		$interface =& remositoryInterface::getInstance();
		$parent = $this->getParent();
		if ($parent != null) $parent->showPathway();
		?>
		<img src="<?php echo $interface->getCfg('live_site') ?>/images/M_images/arrow.png" alt="arrow" />
		<?php
		echo $this->getURL();
		echo $this->name;
		echo '</a>';
	}

	// Alternative to use the CMS pathway instead of a separate Remository one
	function showCMSPathway () {
		$parent = $this->getParent();
		if (!is_null($parent)) $parent->showCMSPathway();
		$interface =& remositoryInterface::getInstance();
		$link = remositoryRepository::RemositoryRawFunctionURL('select', $this->id);
		$interface->appendPathWay($this->name, $link);
	}

	function getIcons () {
		return remositoryRepository::getIcons ('folder_icons');
	}

	function togglePublished ($idlist, $value) {
		$cids = implode( ',', $idlist );
		$sql = "UPDATE #__downloads_containers SET published=$value". "\nWHERE id IN ($cids)";
		remositoryRepository::doSQL ($sql);
	}

}