<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remositoryContainerManager {
	var $remository_links = array();
	var $remository_containers = array();

	function remositoryContainerManager () {
		$sql = 'SELECT * FROM #__downloads_containers ORDER BY sequence, name';
		$this->remository_containers = remositoryRepository::doSQLget($sql,'remositoryContainer');
		foreach ($this->remository_containers as $i=>$container) $this->remository_links[$container->id] = $i;
	}

    function &getInstance () {
        static $instance;
        if (!is_object($instance)) $instance = new remositoryContainerManager();
        return $instance;
    }

    function count () {
        return count($this->remository_containers);
    }

    function &getFromIDs (&$ids) {
    	$result = array();
    	foreach ($ids as $id) $result[] = $this->remository_containers[$this->remository_links[$id]];
    	return $result;
    }

	function &getChildren ($id, $published=true, $search='') {
		$children = array();
		foreach ($this->remository_containers as $i=>$container) {
			if ($container->parentid != $id) continue;
			if ($published AND $container->published == 0) continue;
			if ($search AND strpos($container->name, $search) === false) continue;
			$children[] =& $this->remository_containers[$i];
		}
		return $children;
	}

	function &getVisibleChildren ($id, &$user) {
		$children = array();
		$repository =& remositoryRepository::getInstance();
		foreach ($this->remository_containers as $i=>$container) {
			if ($container->parentid != $id) continue;
			if ($user->isAdmin()) {
				$children [] =& $this->remository_containers[$i];
			}
			else {
				if (0 != $container->published AND ($repository->See_Containers_no_download OR $user->canDownloadContainer($container->id))) {
					$children[] =& $this->remository_containers[$i];
				}
			}
		}
		return $children;
	}

	function &getContainer ($id) {
		if ($id AND isset($this->remository_links[$id])) $container =& $this->remository_containers[$this->remository_links[$id]];
		else $container = null;
		return $container;
	}

	function &getParent ($id) {
		if ($id AND isset($this->remository_links[$id])) $parent =& $this->remository_containers[$this->remository_links[$id]];
		else $parent = null;
		return $parent;
	}

	function delete ($id) {
		$sql = "DELETE FROM #__downloads_containers WHERE id=$id";
		remositoryRepository::doSQL($sql);
		if (isset($this->remository_links[$id]) AND isset($this->remository_containers[$this->remository_links[$id]])) {
			unset($this->remository_containers[$this->remository_links[$id]]);
			unset($this->remository_links[$id]);
		}
	}

	function makeSelectedList ($containers, $type, $parm) {
		$repository =& remositoryRepository::getInstance();
		$ids = explode(',', $containers);
		foreach ($ids as $id) {
			$id = intval($id);
			if (isset($this->remository_links[$id])) $selector[] = $repository->makeOption($id, $this->remository_containers[$this->remository_links[$id]]->name);
		}
		if (isset($selector)) return $repository->selectList ($selector, $type, $parm);
		else return '';
	}

	function &getFilePathData ($path='') {
		$paths = array();
		foreach ($this->remository_containers as $i=>$container) {
			if ($path == '' OR ($path AND ($container->filepath == $path OR $container->filepath == ''))) {
				$paths[] =& $this->remository_containers[$i];
			}
		}
		$containers = array();
		if ($paths) {
			$repository =& remositoryRepository::getInstance();
			$defaultdown = $repository->Down_Path.'/';
			foreach ($paths as $path) {
				if ($path->filepath) $containers[$path->filepath][] = $path->id;
				else $containers[$defaultdown][] = $path->id;
			}
		}
		return $containers;
	}

	function &getFolders ($search='') {
		$folders = array();
		foreach ($this->remository_containers as $i=>$container) {
			if ($search AND strpos(strtolower($container->name), $search) === false) continue;
			$folders[] =& $this->remository_containers[$i];
		}
		return $folders;
	}

	function getCategories ($published=false, $search='') {
		$categories = array();
		foreach ($this->remository_containers as $i=>$container) {
			if ($published AND $container->published == 0) continue;
			if ($container->parentid != 0) continue;
			if ($search AND strpos(strtolower($container->name), $search) === false) continue;
			$categories[] =& $this->remository_containers[$i];
		}
		return $categories;
	}

	function getTreeAdds ($treename='remostree', $addfiles=false) {
		$adds = <<<TREE_ROOT
		
		$treename.add(0, -1, 'Repository', 'javascript:void(0);');
		
TREE_ROOT;

		$max = 0;
		foreach ($this->remository_containers as $container) {
			$max = max($max, $container->id);
			$parent = $container->parentid ? $container->parentid : 0;
			$link = remositoryRepository::RemositoryBasicFunctionURL('select', $container->id);
			$adds .= <<<ADD_ONE

		$treename.add($container->id, $parent, '$container->name', '$link');

ADD_ONE;

		}
		
		if ($addfiles) {
			$interface =& remositoryInterface::getInstance();
			$database = $interface->getDB();
			$database->setQuery("SELECT id, filetitle, containerid FROM #__downloads_files");
			$files = $database->loadObjectList();
			if ($files) foreach ($files as $file) {
				$max++;
				$link = remositoryRepository::RemositoryBasicFunctionURL('fileinfo', $file->id);
				$adds .= <<<ADD_FILE
				
		$treename.add($max, $file->containerid, '$file->filetitle', '$link');
			
ADD_FILE;

			}

		}
		return $adds;
	}

}
