<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remositoryCustomizer {
	
	function getFileListFields () {
		$fields = array(
		array ('smalldesc', _DOWN_DESC_SMALL, 1),
		array ('submittedby', _DOWN_SUB_BY, 1),
		array ('submitdate', _DOWN_SUBMIT_DATE, 1),
		array ('filesize', _DOWN_FILE_SIZE, 1),
		array ('downloads', _DOWN_DOWNLOADS, 1),
		array ('vote_value', _DOWN_RATING, 1),
		array ('license', _DOWN_LICENSE, 0),
		array ('fileversion', _DOWN_FILE_VER, 0),
		array ('fileauthor', _DOWN_FILE_AUTHOR, 0),
		array ('filehomepage', _DOWN_FILE_HOMEPAGE, 0)
		);
		return $fields;
	}

	function checkCustomizer ($repository) {
		if (!$repository->customizer) {
			$fields = $this->getFileListFields();
			foreach ($fields as $key=>$farr) {
				$values['S'][$key] = $key;
				$values['A'][$key] = $values['B'][$key] = $values['C'][$key] = $farr[2];
			}
			if (isset($values)) {
				$repository->customizer = serialize($values);
				$repository->saveValues();
			}
		}
	}
    
}