<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remositoryRepository extends remositoryAbstract {

	/** @var string Remository version number */
	var $version='';
	/** @var book Default to database to store files */
	var $Use_Database='1';
	/** @var string Table classes */
	var $tabclass=null;
	/** @var string Table headers */
	var $tabheader=null;
	/** @var string URL to header picture */
	var $headerpic=null;
	/** @var array Permitted file extensions */
	var $ExtsOk=null;
	/** @var string File extensions for immediate display */
	var $ExtsDisplay=null;
	/** @var string Classification types for tagging */
	var $Classification_Types=null;
	/** @var string Scribd publishing key */
	var $Scribd=null;
	/** @var string Download file path */
	var $Down_Path=null;
	/** @var string Upload file path */
	var $Up_Path=null;
	/** @var int Length of full description (maximum) */
	var $Large_Text_Len=null;
	/** @var int Length of short description (maximum) */
	var $Small_Text_Len=null;
	/** @var int Small Image width (pixels) */
	var $Small_Image_Width=null;
	/** @var int Small Image height (pixels) */
	var $Small_Image_Height=null;
	/** @var int Large Image width (pixels) */
	var $Large_Image_Width=null;
	/** @var int Large Image height (pixels) */
	var $Large_Image_Height=null;
	/** @var bool Allow Large images to be popped up */
	var $Allow_Large_Images=1;
	/** @var bool Use Remository own pathway */
	var $Remository_Pathway=0;
	/** @var int Maximum file size in Kbytes */
	var $MaxSize=null;
	/** @var int Maximum uploads per user per day */
	var $Max_Up_Per_Day=null;
	/** @var int Maximum downloads per user per day */
	var $Max_Down_Per_Day=null;
	/** @var int Maximum downloads per registered user per day */
	var $Max_Down_Reg_Day=null;
	/** @var int Maximum downloads per file per day */
	var $Max_Down_File_Day=null;
	/** @var int Maximum space allowed for files directory */
	var $Max_Up_Dir_Space=null;
	/** @var int Number of favourites to be marked by a registered user */
	var $Favourites_Max=null;
	/** @var int Maximum number of thumbnail image files, 0 = use URL in file data */
	var $Max_Thumbnails=0;
	/** @var bool Make automatic thumbnail for image file */
	var $Make_Auto_Thumbnail=0;
	/** @var string Default Version Number */
	var $Default_Version=null;
	/** @var string Date format string for PHP data function  */
	var $Date_Format=null;
	/** @var bool Anti Leach in effect */
	var $Anti_Leach=null;
	/** @var bool Allow uploads that overwrite an earlier file */
	var $Allow_Up_Overwrite=null;
	/** @var bool Allow users to submit files */
	var $Allow_User_Sub=null;
	/** @var bool Allow users to edit existing file information */
	var $Allow_User_Edit=null;
	/** @var bool Allow users to delete the files they submitted */
	var $Allow_User_Delete=null;
	/** @var bool Allow users to upload files */
	var $Allow_User_Up=null;
	/** @var bool Enable Auto approve and publish for admin */
	var $Enable_Admin_Autoapp=null;
	/** @var bool Enable Auto approve and publish for registered users */
	var $Enable_User_Autoapp=null;
	/** @var bool Allow comments on files */
	var $Allow_Comments=null;
	/** @var bool Allow votes on files */
	var $Allow_Votes=null;
	/** @var bool Enable downloads directly from a list of files */
	var $Enable_List_Download=null;
	/** @var bool Show pathway through filebase */
	var $User_Remote_Files=null;
	/** @var bool Let users see containers where download not permitted */
	var $See_Containers_no_download='1';
	/** @var bool Let users see files that are not permitted to be downloaded */
	var $See_Files_no_download='1';
	/** @var bool Show RSS feed */
	var $Show_RSS_feeds='1';
	/** @var bool Send mail when a file is submitted */
	var $Send_Sub_Mail=null;
	/** @var string Submit Mail Alt Add */
	var $Sub_Mail_Alt_Addr=null;
	/** @var string Submit Mail Alt Name */
	var $Sub_Mail_Alt_Name=null;
	/** @var time Timestamp for authentication */
	var $Time_Stamp;
	/** @var string Information to be displayed during download */
	var $download_text = '';
	/** @var string Information to be displayed at start of main page */
	var $preamble = '';
	/** @var string Default Licence for downloads */
	var $Default_Licence = '';
	/** @var string Custom field control - serialized array */
	var $customizer = '';
	
	function remositoryRepository () {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		if (true OR $type=='GLOBAL') {
			$mosConfig_live_site = $interface->getCfg('live_site');
			$sql = "SELECT * FROM #__downloads_repository WHERE id=0";
			if (!$this->readDataBase($sql)) {
				$mosConfig_absolute_path = $interface->getCfg('absolute_path');
				require ($mosConfig_absolute_path.'/components/com_remository/com_remository_settings.php');
				$this->id = 0;
				foreach (get_class_vars(get_class($this)) as $k=>$v) {
					if(isset($$k)) $this->$k = $$k;
					else $this->$k = '';
				}
				$this->saveValues();
			}
		}
		foreach (get_class_vars(get_class($this)) as $k=>$v) {
			$this->$k = str_replace ('{live_site}', $mosConfig_live_site, $this->$k);
		}
	}

    function &getInstance () {
        static $instance;
        if (!is_object($instance)) $instance = new remositoryRepository();
        return $instance;
    }

	function tableName () {
		return '#__downloads_repository';
	}

	function getVarText() {
		$txt = '';
		$this->Time_Stamp = time();
		foreach (get_class_vars(get_class($this)) as $k=>$v) {
			if (substr($k,0,1) != '_') {
				if (is_numeric($this->$k)){
					$txt .= "\$$k = ".intval($this->$k).";\n";
				} elseif (strlen($k) > 0) $txt .= "\$$k = \"".addslashes( $this->$k )."\";\n";
			}
		}
		return $txt;
	}

	function saveValues () {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$this->forceBools();
		$this->id = 0;
		$sql = 'SELECT COUNT(id) FROM #__downloads_repository WHERE id = 0';
		$database->setQuery($sql);
		if ($database->loadResult()) $sql = $this->updateSQL();
		else $sql = $this->insertSQL();
		remositoryRepository::doSQL ($sql);
	}
	
	function searchRepository($search_text, $seek_fields, &$user, $pagecontrol, $countOnly=false) {
		if (!$search_text) return $countOnly ? 0 : array();
		if ($countOnly) {
			$sql = remositoryFile::searchFilesSQL($search_text, $seek_fields, $user, $this, true);
			$interface =& remositoryInterface::getInstance();
			$database =& $interface->getDB();
			$database->setQuery($sql);
			return $database->loadResult();
		}
		$sql = remositoryFile::searchFilesSQL($search_text, $seek_fields, $user, false, $pagecontrol->startItem(), $pagecontrol->itemsperpage);
		return $this->doSQLget($sql,'remositoryFile');
	}

	function badExtension ($filepath) {
		$ext = $this->lastPart($filepath, '.');
		if (trim($this->ExtsOk) != '*' AND !in_array($ext,$this->getExtensionsOK())) {
			echo "<script> alert('"._ERR4.' ('.$ext.")'); window.history.go(-1); </script>\n";
			return true;
		}
		return false;
	}

	function getUploadLimit () {
		return $this->maxUploads;
	}

    function canUserSubmit () {
    	return $this->userSubmit;
    }

	function getTableClasses () {
		return explode(",",$this->tabclass);
	}

	function getExtensionsOK () {
		return explode(",",strtolower($this->ExtsOk));
	}

	function getSelectList ($allowTop, $default, $type, $parm, &$user, $usable=false) {
		if ($allowTop) $selector[] = $this->makeOption(0,_DOWN_NO_PARENT);
		else $selector = array();
		$manager =& remositoryContainerManager::getInstance();
		foreach ($manager->getCategories() as $category) $category->addSelectList('', $selector, null, $user, $usable);
		if (count($selector)) return $this->selectList( $selector, $type, $parm, $default );
		else return '';
	}

	function &getIcons ($location) {

		$interface =& remositoryInterface::getInstance();

		$mosConfig_live_site = $interface->getCfg('live_site');
		$iconList='';
		$handle=@opendir($interface->getCfg('absolute_path').'/components/com_remository/images/'.$location);
		if ($handle) {
			$ss = 0;
			while (($file = readdir($handle))!==false) {
				if ($file != "." && $file != "..") {
					$iconList.="\n\t\t\t\t<a href=\"JavaScript:paste_strinL('{$file}')\" onmouseover=\"window.status='{$file}'; return true\"><img src=\"{$mosConfig_live_site}/components/com_remository/images/{$location}/{$file}\" width=\"32\" height=\"32\" alt=\"{$file}\" /></a>&nbsp;&nbsp;";
					/*
			        $ss++;
					if ($ss>=10) {
						$ss = 0;
						$iconList.="<br/>\n";
					}
					*/
				}
			}
   			closedir($handle);
			if ($iconList=='') $iconList="_DOWN_NOT_AUTH";
		}
		return $iconList;
	}

	function &requireCategories () {
		$manager =& remositoryContainerManager::getInstance();
		$cats = $manager->getCategories();
		if (count($cats)==0){
			echo "<script> alert('"._DOWN_NO_CAT_DEF."'); </script>\n";
			$interface =& remositoryInterface::getInstance();
			$interface->redirect( "index2.php?option=com_remository" );
		}
		return $cats;
	}

	function resetCounts ($chain=null) {
		$manager =& remositoryContainerManager::getInstance();
		$categories = $manager->getCategories();
		if (is_array($chain)) $this->doSQL('TRUNCATE TABLE #__downloads_structure');
		foreach ($categories as $category) $category->setFileCount($chain);
	}

	function getFiles ($search='', $limitstart=0, $limit=0) {
		$sql = remositoryFile::getFilesSQL(true, false, 0, true, 2, $search, $limitstart, $limit);
		return $this->doSQLget($sql,'remositoryFile');
	}

	function getFilesCount ($search) {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$sql = remositoryFile::getFilesSQL(true, true, 0, true, 2, $search);
		$database->setQuery( $sql );
		return $database->loadResult();
	}

	function getTempFiles () {
		$sql = "SELECT * FROM #__downloads_files WHERE metatype > 0 ORDER BY id";
		$results = $this->doSQLget($sql,'remositoryTempFile');
		foreach ($results as $key=>$result) $results[$key]->containerid = -$result->containerid;
		return $results;
	}

	function RemositoryFunctionURL ($func=null, $idparm=null, $os=null, $orderby=null, $item=null) {

		return '<a href="'.remositoryRepository::RemositoryBasicFunctionURL($func,$idparm,$os,$orderby,$item).'">';

	}

	function RemositoryRawFunctionURL ($func=null, $idparm=null, $os=null, $orderby=null, $item=null, $fname=null ) {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();

		if (!defined('_ALIRO_IS_PRESENT')) {
			if (isset($GLOBALS['remosef_itemids']['com_remository'])) $Itemid = $GLOBALS['remosef_itemids']['com_remository'];
			else {
				$database->setQuery("SELECT id, (CASE menutype WHEN 'mainmenu' THEN 1 WHEN 'topmenu' THEN 2 WHEN 'othermenu' THEN 3 ELSE 99 END) menorder"
					." FROM #__menu WHERE link = 'index.php?option=com_remository' AND published=1 ORDER BY menorder");
				$GLOBALS['remosef_itemids']['com_remository'] = $Itemid = $database->loadResult();
			}
			$url = 'index.php?option=com_remository&Itemid=';
			if ($item) $url .= $item;
			else $url .= intval($Itemid);
		}
		else $url = 'index.php?option=com_remository';
		if ($func) $url .= '&func='.$func;
		if ($idparm) $url .= '&id='.$idparm;
		if (!$os) $os = remositoryRepository::getParam($_REQUEST,'os',null);
		if (!in_array($os,array('win','mac','linux','all'))) $os = null;
		if ($os AND $os != 'All') $url .= '&os='.$os;
		if ($orderby) $url .= '&orderby='.$orderby;
		if ($func == 'download') $url .= '&chk='.$this->makeCheck($idparm,$func).'&no_html=1';
		elseif ($func == 'rss') $url .= '&no_html=1';
		// if ($fname) $url .= '&fname='.urlencode($fname);
		$thisfunc = remositoryRepository::getParam($_REQUEST, 'func');
		if ('direct' == substr($thisfunc,0,6)) {
			if (!$func) $url .= '&func=directlist';
			$url .= '&indextype=2';
		}
		return $url;
	}

	function RemositoryBasicFunctionURL ($func=null, $idparm=null, $os=null, $orderby=null, $item=null, $fname=null ) {
		$interface =& remositoryInterface::getInstance();
		$url = remositoryRepository::RemositoryRawFunctionURL($func, $idparm, $os, $orderby, $item, $fname);
		if (!defined('REMOSITORY_ADMIN_SIDE')) $url = $interface->sefRelToAbs($url);
		$ampencode = '/(&(?!(#[0-9]{1,5};))(?!([0-9a-zA-Z]{1,10};)))/';
		return preg_replace($ampencode, '&amp;', $url);
		return $url;
	}

	function wrongCheck ($chk, $id, $func) {

		if ($chk == $this->makeCheck($id, $func)) return false;
		return true;
	}

	function makeCheck ($id, $func) {

		$interface =& remositoryInterface::getInstance();
		return md5($this->Time_Stamp.$interface->getCfg('absolute_path').date('md').$id.$func);
	}

	// Containerid may be needed for notification by email of intererested people
	function sendAdminMail ($user_full, $filetitles, $containerid, $published=true) {
		$interface =& remositoryInterface::getInstance();
		// Site name and live site are needed for evaluation of message text below
		// as is the user_full parameter
		$mosConfig_live_site = $interface->getCfg('live_site');
		$mosConfig_sitename = $interface->getCfg('sitename');
		$mailfrom = $interface->getCfg('mailfrom');
		$fromname = $interface->getCfg('fromname');
		$superadmin = remositoryUser::superAdminMail();
		//if ($this->Sub_Mail_Alt_Addr=='') $recipient = 'Administrator <'.$superadmin.'>';
	    //else $recipient = "$this->Sub_Mail_Alt_Name <$this->Sub_Mail_Alt_Addr>";
	    // Only the simplified version seems to work with J 1.0.x
		if ($this->Sub_Mail_Alt_Addr=='') $recipient = $superadmin;
	    else $recipient = $this->Sub_Mail_Alt_Addr;
		$subject = $interface->getCfg('sitename').':'._DOWN_MAIL_SUB;
		if ($published) $message = _DOWN_MAIL_MSG_APP;
		else $message = _DOWN_MAIL_MSG;
		$message .= "\n"._DOWN_FILE_TITLE."\n". $filetitles;
		eval ("\$message = \"$message\";");
		if ($mailfrom) $interface->sendMail ($mailfrom, $fromname, $recipient, $subject, $message);
		else $interface->sendMail ($superadmin, 'Administrator', $recipient, $subject, $message);
	}

	function RemositoryImageURL($imageName, $width=32, $height=32, $title='') {

		$interface =& remositoryInterface::getInstance();

		$element = '<img src="';
		$element .= $interface->getCfg('live_site').'/components/com_remository/images/'.$imageName;
		$element .= '" width="';
		$element .= $width;
		$element .= '" height="';
		$element .= $height;
		if ($title) {
			$element .= '" title="';
			$element .= $title;
		}
		$element .= '" alt="';
		$element .= $imageName;
		$element .= '"/>';
		return $element;

	}

	function doSQL ($sql) {
		if ($sql) {
			$interface =& remositoryInterface::getInstance();
			$database =& $interface->getDB();
			$database->setQuery($sql);
			if (!$database->query()) {
				echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
				exit();
			}
		}
	}

	function &doSQLget ($sql, $classname) {
		if ($sql) {
			$interface =& remositoryInterface::getInstance();
			$database =& $interface->getDB();
			$database->setQuery($sql);
			$rows = $database->loadObjectList();
		}
		else $rows = null;
		$target = get_class_vars($classname);
		if ($rows) {
			foreach ($rows as $row) {
				$next =& new $classname(0);
				foreach (get_object_vars($row) as $field=>$value) {
					if (isset($target[$field])) $next->$field = $value;
				}
				$result[] = $next;
			}
		}
		else $result = (array());
		return $result;
	}

	function makeOption($value, $text='', $value_name='value', $text_name='text') {
		$obj = new stdClass;
		$obj->$value_name = $value;
		$obj->$text_name = trim($text) ? $text : $value;
		return $obj;
	}

	function selectList (&$arr, $tag_name, $tag_attribs='', $selected=NULL, $key='value', $text='text' ) {
		$html = "\n\t\t<select name=\"$tag_name\" $tag_attribs>";
		foreach ($arr as $option) {
			$picked = '';
			if (is_array($selected)) {
				if (in_array($option->$key, $selected)) $picked = 'selected="selected"';
			}
			elseif ($option->$key == $selected) $picked = 'selected="selected"';
			$html .= "\n\t\t\t<option value='{$option->$key}' $picked>{$option->$text}</option>";
		}
		$html .= "\n\t\t</select>\n";
		return $html;
	}

	function getParam (&$array, $name, $default='') {
		$interface =& remositoryInterface::getInstance();
		if (!empty($array[$name])) {
			if (is_numeric($default)) return intval($array[$name]);
			else return $interface->purify($array[$name]);
		}
		else return $default;
	}

}
