<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remositoryUser {
	/** @var int ID for the user in the database */
	var $id=0;
	/** @var bool Is the current user of administrator status? */
	var $admin=false;
	/** @var bool Is the current user logged in?  */
	var $logged=false;
	/** @var string User name if loggged in */
	var $name='';
	/** @var string User full name if logged in */
	var $fullname='';
	/** @var string User type if logged in */
	var $usertype='';
	/** @var string User current IP address */
	var $currIP='';
	/** @var array Downloads so far today by file ID */
	var $downloads = array();
	/** @var int Total downloads all files today */
	var $totaldown = 0;
	/** @var array Container IDs where user does not have permission */
	var $refused=array();

	/**
	* File object constructor
	* @param int Directory full path
	*/
	function remositoryUser ( $id=0, $my=null ) {
		$interface =& remositoryInterface::getInstance();
		$this->id = $id;
		if ($id) {
			if (!$my) $my = $interface->getIdentifiedUser($id);
			if ($my->gid) {
				$this->name = $my->username;
				$this->fullname = $my->name;
				$this->usertype = $my->usertype;
				$this->logged = true;
				if ((strtolower($my->usertype)=='administrator') OR (strtolower($my->usertype)=='superadministrator')
						OR (strtolower($my->usertype)=='super administrator')){
					$this->admin = true;
				}
			}
			if (isset($my->jaclplus)) $this->jaclplus = $my->jaclplus;
			$results = $this->loggedCount();
		}
		else $results = $this->nonLoggedCount();
		if ($results) foreach ($results as $result) {
			$this->downloads[$result->fileid] = $result->number;
			$this->totaldown += $result->number;
		}
		$this->currIP = getenv('REMOTE_ADDR');
		$authoriser =& aliroAuthoriser::getInstance();
		$this->refused = $authoriser->getRefusedList ('aUser', $this->id, 'remosFolder', 'download,edit');
	}

	function isAdmin () {
		return $this->admin;
	}
	function isUser () {
		if ($this->isAdmin()) return false;
		return $this->isLogged();
	}
	function isLogged () {
		return $this->logged;
	}
	function fullname () {
		return $this->fullname;
	}
	function canDownloadContainer($id) {
		return (!in_array($id, $this->refused));
	}
	function uploadsToday () {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();

		$today = date('Y-m-d');
		$sql="SELECT COUNT(*) from #__downloads_files WHERE submittedby=".$this->id." AND submitdate LIKE '".$today."%'";
		$database->setQuery($sql);
		return $database->loadResult();
	}

	function allowUploadCheck ($container) {
		if ($this->isAdmin()) return;
		$repository =& remositoryRepository::getInstance();
		if (!$repository->Allow_User_Sub) {
			echo "<script> alert('"._DOWN_NOT_AUTH."'); window.history.go(-1); </script>\n";
			exit();
		}
		$authoriser =& aliroAuthoriser::getInstance();
		if ($authoriser->checkPermission ('aUser', $this->id, 'upload', 'remosFolder', $container->id)
		OR $authoriser->checkPermission ('aUser', $this->id, 'edit', 'remosFolder', $container->id)) {
			if ($this->logged) {
				if ($this->uploadsToday() > $repository->Max_Up_Per_Day) {
					?><SCRIPT>alert("<?php echo _ERR9; ?>")</SCRIPT><?php
					remositoryUserHTML::pathwayHTML( null );
					?><br/>&nbsp;<br/><?php echo _DOWN_ALL_DONE;
					exit();
				}
			}
			return;
		}
		echo "<script> alert('"._DOWN_NOT_AUTH."'); window.history.go(-1); </script>\n";
		exit();

	}

	function hasAutoApprove ($container) {
		if (!$this->isLogged()) return false;
		$repository =& remositoryRepository::getInstance();
		if ($this->isAdmin()) {
			if ($container->adminauto) return true;
			if ($repository->Enable_Admin_Autoapp) return true;
		}
		else {
			if ($repository->Enable_User_Autoapp) return true;
			// if ($container->userauto AND remositoryGroup::isUserMember($container->autogroup, $this)) return true;
		}
		return false;
	}

	function superAdminMail () {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$sql="select email, name from #__users where usertype='superadministrator' or usertype='super administrator'";
		$database->setQuery( $sql );
		$row=null;
		$result = $database->loadObject( $row );
		if (is_object($result)) $row = $result;
		if ($row) return $row->email;
    	else return null;
	}

	function nonLoggedCount () {
		$interface =& remositoryInterface::getInstance();
		$ipaddress = getenv('REMOTE_ADDR');
		$database =& $interface->getDB();
		$type = _LOG_DOWNLOAD;
		$database->setQuery("SELECT fileid, COUNT(fileid) AS number FROM #__downloads_log WHERE type = $type AND ipaddress = '$ipaddress' AND date > SUBDATE(NOW(), INTERVAL 24 HOUR) GROUP BY fileid");
		return $database->loadObjectList();
	}

	function loggedCount () {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$type = _LOG_DOWNLOAD;
		$database->setQuery("SELECT fileid, COUNT(fileid) AS number FROM #__downloads_log WHERE type = $type AND userid = $this->id AND date > SUBDATE(NOW(), INTERVAL 24 HOUR) GROUP BY fileid");
		return $database->loadObjectList();
	}

	function downloadCount ($id) {
		return isset($this->downloads[$id]) ? $this->downloads[$id] : 0;
	}

	function totalDown () {
		return $this->totaldown;
	}
}

?>
