<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

// Don't allow direct linking
if (!defined( '_VALID_MOS' ) AND !defined('_JEXEC')) die( 'Direct Access to this location is not allowed.' );

$remository_dir = str_replace('\\','/',dirname(__FILE__));
require_once ($remository_dir.'/com_remository_constants.php');

if ('5' > phpversion() OR !defined('_ALIRO_IS_PRESENT')) {
	require_once($remository_dir.'/remository.interface.php');
	require_once ($remository_dir.'/p-classes/remositoryAuthoriser.php');
	require_once ($remository_dir.'/p-classes/remositoryFile.php');
	require_once ($remository_dir.'/p-classes/remositoryTempFile.php');
	require_once ($remository_dir.'/p-classes/remositoryPhysicalFile.php');
	require_once ($remository_dir.'/p-classes/remositoryContainerManager.php');
	require_once ($remository_dir.'/p-classes/remositoryContainer.php');
	require_once ($remository_dir.'/p-classes/remositoryClassification.php');
	require_once ($remository_dir.'/p-classes/remositoryClassificationHandler.php');
	require_once ($remository_dir.'/p-classes/remositoryUser.php');
	// require_once ($remository_dir.'/p-classes/remositoryGroup.php');
	require_once ($remository_dir.'/p-classes/remositoryRepository.php');
	require_once ($remository_dir.'/p-classes/remositoryDirectory.php');
	require_once ($remository_dir.'/p-classes/remositoryThumbnails.php');
	require_once ($remository_dir.'/p-classes/remositoryComment.php');
	require_once ($remository_dir.'/p-classes/remositoryLogEntry.php');
	require_once ($remository_dir.'/p-classes/remositoryCustomizer.php');
}

/**
* Abstract class for Remository classes that involve straightforward database tables
* Requires child classes to implement: tableName(), notSQL().
* tableName() must return the name of the database table, using #__ in the usual Mambo way
* notSQL() must return an array of strings, where each string is the name of a
* 	variable that is NOT in the database table, or is not written explicitly,
*   e.g. the auto-increment key.  If this is the ONLY non-SQL field, then the
*   child class need not implement it, as that it is already in the abstract class.
* Child classes may optionally implement: forcebools().
*/

class remositoryAbstract {
	/** @var int ID for file record in database */
	var $id=0;
	/** @var int Sequencing number for records */
	var $sequence=0;
	/** @var string Window Title */
	var $windowtitle='';
	/** @var string Keywords */
	var $keywords='';

	function remositoryAbstract () {
		die ('Cannot instantiate remositoryAbstract');
	}

	function addPostData () {
		$interface =& remositoryInterface::getInstance();
		foreach (get_class_vars(get_class($this)) as $field=>$value) {
			if ($field!='id' AND isset($_POST[$field]) AND !is_array($_POST[$field])) {
				$this->$field = trim($_POST[$field]);
				if ($this->$field AND !is_numeric($this->$field)) $this->$field = $interface->purify($this->$field);
			}
		}
		$this->forceBools();
  	}

	function forceBools () {
	}

	function updateObjectDB () {
		remositoryRepository::doSQL($this->updateSQL());
	}

	function timeStampField () {
		return '';
	}

	function prepareValues () {
		$interface =& remositoryInterface::getInstance();
		foreach (get_class_vars(get_class($this)) as $field=>$value) {
			if (!is_numeric($this->$field)) $this->$field = $interface->getEscaped($this->$field);
		}
	}

	function updateSQL () {
		$interface =& remositoryInterface::getInstance();
		$tabname = $this->tableName();
		$sql = "UPDATE $tabname SET ";
		$exclude = $this->notSQL();
		foreach (get_class_vars(get_class($this)) as $field=>$value) {
			if (!in_array($field,$exclude)) {
				$data = is_numeric($this->$field) ? $this->$field : $interface->getEscaped($this->$field);
				$item[] = $field."='".$data."'";
			}
		}
		if ($this->timeStampField()) $item[] = $this->timeStampField()."='".date('Y-m-d H:i:s')."'";
		if (isset($item)) {
			$sql .= implode (', ', $item);
		}
		return $sql.' WHERE id='.$this->id;
	}

	function notSQL () {
		return array ('id');
	}

	function insertSQL () {
		$interface =& remositoryInterface::getInstance();
		$tabname = $this->tableName();
		$exclude = $this->notSQL();
		foreach (get_class_vars(get_class($this)) as $field=>$value) {
			if (!in_array($field,$exclude)) {
				$column[] = $field;
				$data = is_numeric($this->$field) ? $this->$field : $interface->getEscaped($this->$field);
				$item[] = "'".$data."'";
			}
		}
		$timestamp = $this->timeStampField();
		if ($timestamp) {
			$column[] = $timestamp;
			$item[] = "'".date('Y-m-d H:i:s')."'";
		}
		$columns = implode(',', $column);
		$datafields = implode(',', $item);
		return "INSERT INTO $tabname ($columns) VALUES($datafields)";
	}

	function setValues (&$anObject) {
		foreach (get_class_vars(get_class($this)) as $field=>$value) {
			if ($field != 'id' AND isset($anObject->$field)) $this->$field = $anObject->$field;
		}
	}

	function readDataBase($sql) {
		$interface =& remositoryInterface::getInstance();
		$database =& $interface->getDB();
		$database->setQuery( $sql );
		if (!($result = $database->loadObject($this))) $this->id = 0;
		if (is_object($result)) $this->setValues($result);
		return $result ? true : false;
	}

	function lastPart ($field, $separator, $lowercase=true) {
        $split_array = explode ( $separator, $field);
		$last = $split_array[count($split_array)-1];
		if ($lowercase) return strtolower($last);
		return $last;
	}

	function allButLast ($field, $separator) {
		$last = remositoryAbstract::lastPart($field,$separator);
		return substr($field,0,strlen($field)-strlen($last)-1);
	}

	function visibilitySQL (&$user, $see_objects) {
		$sql = '';
		if (!$user->isAdmin()) {
			$sql .= " AND f.published=1";
			if (!$see_objects) {
				$authoriser =& aliroAuthoriser::getInstance();
				$refuseSQL = $authoriser->getRefusedListSQL ('aUser', $user->id, 'remosFolder', 'download,edit', 'f.containerid');
				if ($refuseSQL) $sql .= ' AND '.$refuseSQL;
				/*
				$grouplist = remositoryGroup::getMembersGroupList ($user);
				if (strlen($grouplist)) $sql .= " AND ((f.registered & 2) OR ((f.userupload & 2) AND f.groupid IN ($grouplist)))";
				else $sql .= " AND (f.registered & 2)";
				*/
			}
		}
		return $sql;
	}

}

?>