<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class remositoryUserHTML {
	var $controller = '';
	var $repository = '';
	var $interface = '';
	var $remUser = '';
	var $submitok = false;
	var $submit_text = '';
	var $orderby = _REM_DEFAULT_ORDERING;
	var $mainpicture = '';

	function remositoryUserHTML (&$controller) {
		$this->controller = $controller;
		$this->interface =& remositoryInterface::getInstance();
		$this->repository = $controller->repository;
		$this->mainpicture = $this->repository->headerpic;
		$thumb_width_x = $this->repository->Small_Image_Width + 20;
		$thumb_width_x_plus = $thumb_width_x + 20;
		$thumb_height_y = $this->repository->Small_Image_Height + 50;

		$css = <<<end_css
<style type='text/css'>
/* Remository specific CSS requiring variables */
#remositorypageheading {
	background-image:	url($this->mainpicture);
}
.remositoryfilesummary
{
	margin-right:	{$thumb_width_x_plus}px;
}
.remositoryonethumb {
	width: {$thumb_width_x}px;
}
.remositorydelthumb {
	height:		{$thumb_height_y}px;
}
/* End of variable Remository CSS */
</style>
end_css;

		$this->interface->addCustomHeadTag($css);

		$baselink = $this->interface->getCfg('live_site').'/components/';
		$basedir = $this->interface->getCfg('absolute_path').'/components/';
		$cssfile = file_exists($basedir.'com_remository_files/custom.css') ? $baselink.'com_remository_files/custom.css' : $baselink.'com_remository/remository.css';
		$css = "\n<link href='$cssfile' rel='stylesheet' type='text/css' />";
		$this->interface->addCustomHeadTag($css);

		$this->remUser = $controller->remUser;
		$this->submitok = $controller->submitok;
		$this->submit_text = $controller->submit_text;
		$this->orderby = $controller->orderby;
	}

	function fileOutputBox ($title, $value, $suppressHTML=false) {
	    if ($suppressHTML) $value = htmlspecialchars($value);
		echo <<<OUTPUT_BOX
		<dt>$title</dt>
		<dd>
		  $value
		</dd>
OUTPUT_BOX;
	}

	function mainPageHeading ($belowTop) {
		$title = _DOWNLOADS_TITLE;
		if ($title OR $this->mainpicture) {
			if ($belowTop) $headlevel = 'h3';
			else $headlevel = 'h2';
			echo "\n\t<div id='remositorypageheading'>";
			// if ($this->mainpicture != '') echo "\n\t\t<img src='$this->mainpicture' alt='Header'/>";
			echo "\n\t\t<$headlevel>$title ";
			// The following three lines create RSS links - now controlled by config
			if ($this->repository->Show_RSS_feeds) {
				$rssurl = $this->repository->RemositoryBasicFunctionURL('rss');
				$this->interface->addCustomHeadTag("<link rel='alternate' type='application/rss+xml' title='RSS - "._DOWN_NEWEST."' href='$rssurl' />");
				echo "<a href='".$rssurl."'>".$this->repository->RemositoryImageURL('feedicon16.gif',16,16)." RSS</a>";
			}
			// End of RSS link code
			echo "</$headlevel>";
			echo "\n\t<!-- End of remositorypageheading-->";
			echo "\n\t</div>\n";
			if (!$belowTop AND $this->repository->preamble) echo <<<PREAMBLE

			<div id="remositorypreamble">
				{$this->repository->preamble}
			</div>

PREAMBLE;
		}
	}

	function folderListHeading($container){
		$cname = htmlspecialchars($container->name);
		echo "\n\t<div id='remositorycontainer'>";
		echo "\n\t\t<h2>$cname ";
		// The following three lines create the RSS link for the container - now controlled by config
		if ($this->repository->Show_RSS_feeds) {
			$rssurl = $this->repository->RemositoryBasicFunctionURL('rss', $container->id);
			$this->interface->addCustomHeadTag("<link rel='alternate' type='application/rss+xml' title='RSS - "._DOWN_NEWEST." - $cname' href='$rssurl' />");
			echo "<a href='$rssurl'>".$this->repository->RemositoryImageURL('feedicon16.gif',16,16).' RSS</a>';
		}
		// End of RSS code
		echo '</h2>';
		echo "\n\t\t<p>".$container->description.'</p>';
		echo "\n\t<!-- End of remositorycontainer -->";
		echo "\n\t</div>";
	}

	// To suppress the credits line, change the default for $show_credits to false
	// If you do this, please also consider making a donation to the Remository project!
	function remositoryCredits ($show_credits=true) {
		$version = _REMOSITORY_VERSION;
		echo "\n\t<div id='remositorycredits'>";
		if ($show_credits) echo "\n\t\t<a href='http://www.remository.com'>Remository $version</a> is technology by <a href='http://guru-php.com'>Guru PHP</a>";
		echo "\n\t<!-- End of remositorycredits-->";
		echo "\n\t</div>\n";
	}

	function pathwayHTML ($parent) {
		$repository = remositoryRepository::getInstance();
		if (0 == ($repository->Remository_Pathway & 2)) return;
		echo "\n\t<div id='remositorypathway'>";
		echo "\n\t\t".$this->repository->RemositoryFunctionURL().$this->repository->RemositoryImageURL('gohome.gif').' '._MAIN_DOWNLOADS.'</a>';
		if ($parent) {
			echo "\n\t\t";
			$parent->showPathway();
		}
		echo "\n\t<!-- End of remositorypathway-->";
		echo "\n\t</div>\n";
	}

	// Extra function needed to integration pathway into CMS pathway
	function pathwayImage () {
		$interface =& remositoryInterface::getInstance();
		$imagePath =  '/templates/'.$interface->getTemplate().'/images/arrow.png';
		if (file_exists( $interface->getCfg('absolute_path').$imgPath )) $image = '<img src="' . $interface->getCfg('live_site'). $imagePath . '" border="0" alt="arrow" />';
		else {
			$imagePath = '/images/M_images/arrow.png';
			if (file_exists( $interface->getCfg('absolute_path') . $imagePath )) $image = '<img src="' . $interface->getCfg('live_site') . $imagePath .'" alt="arrow" />';
			else $image = '&gt;';
		}
		return $image;
	}

	function URLDisplay ($text, $value) {
		if (!eregi(_REMOSITORY_REGEXP_URL,$value)) {
			if (eregi(_REMOSITORY_REGEXP_URL,'http://'.$value)) $value = 'http://'.$value;
			else {
				echo "\n\t\t\t<dt>$text</dt>";
				echo "\n\t\t\t<dd>$value</dd>";
				return;
			}
		}
		echo "\n\t\t\t<dt>$text</dt>";
		echo "\n\t\t\t<dd><a href='$value'>"._DOWN_CLICK_TO_VISIT.'</a></dd>';
	}
	
	function filesFooterHTML () {
		$fsearch = $this->footerSearchHTML();
		$fsubmit = $this->footerSubmitHTML();
		echo <<<FILES_FOOTER
		
		<div id='remositoryfooter'>
			$fsearch
			$fsubmit
		<!-- End of remositoryfooter-->
		</div>
		
FILES_FOOTER;

	}
	
	function footerSearchHTML () {
		$text = _DOWN_SEARCH;
		$surl = $this->repository->RemositoryFunctionURL('search');
		$simg = $this->repository->RemositoryImageURL('search.gif');
		return <<<FOOTER_SEARCH
		
		<div id='left'>
			$surl
			$simg
			$text</a>
		</div>
		
FOOTER_SEARCH;

	}
	
	function footerSubmitHTML () {
		if (!$this->repository->Allow_User_Sub) return '';
		if ($this->submitok) {
			$idparm = remositoryRepository::GetParam($_REQUEST, 'id', 0);
			$startlink = $this->repository->RemositoryFunctionURL('addfile', $idparm);
			$endlink = _SUBMIT_FILE_BUTTON.'</a>';
		}
		else {
			$startlink = '';
			$endlink = $this->submit_text;
		}
		$subimage = $this->repository->RemositoryImageURL('add_file.gif');
		return <<<FOOTER_SUBMIT
		
		<div id='right'>
			$startlink
			$subimage
			$endlink
		</div>
		
FOOTER_SUBMIT;

	}

	function fileListing ($file, $container, $downlogo, $remUser, $showContainer=false, $type='A', $downlinktype=0) {
		$thumbnails = new remositoryThumbnails($file);
		$filefunc = $downlinktype ? 'directinfo' : 'fileinfo';
		$downlink = $this->repository->RemositoryFunctionURL($filefunc,$file->id);
		if ($file->icon == '') $downlink .= $this->repository->RemositoryImageURL('stuff1.gif');
		else $downlink .= $this->repository->RemositoryImageURL('file_icons/'.$file->icon);
		$downlink .= $file->filetitle.'</a>';
		if ($this->repository->Enable_List_Download AND is_object($container) AND $container->isDownloadable($this->remUser)) {
				$downlink .= $file->downloadLink($downlinktype).' '.$downlogo.' '._DOWNLOAD.'</a>';
		}
		if ($showContainer AND is_object($container)) $downlink .= ' ('.remositoryRepository::RemositoryFunctionURL('select', $container->id).$container->name.'</a>)';
		
		$thumbdisplay = $thumbnails->displayOneThumbnail();
		echo <<<BEFORE_DETAILS
		
			<div class='remositoryfileblock'>
				<h3>$downlink</h3>
   				<div class='remositoryonethumb'>
   					$thumbdisplay
   				<!-- End of remositoryonethumb -->
   				</div>
   				<div class='remositoryfilesummary'><dl>
   			
BEFORE_DETAILS;

		$this->showFileDetails($file, $remUser, $type);
		
		echo <<<AFTER_DETAILS
		
				<!-- End of remositoryfilesummary -->
				</dl></div>
			<!-- End of remositoryfileblock -->
			</div>

AFTER_DETAILS;

	}
	
	function showFileDetails ($file, $remUser, $type, $dodisplay=true) {
		if ($dodisplay AND $remUser->isAdmin()) $this->fileOutputBox(_DOWN_PUB, ($file->published == 1 ? _YES : _NO), false);

		$customcontrol = unserialize($this->repository->customizer);
		$customobj = new remositoryCustomizer();
		$fieldnames = $customobj->getFileListFields();
		$order = array();
		$count = 0;
		foreach ($customcontrol['S'] as $key=>$sequence) $order[$sequence] = $key;
		ksort($order);
		if (count($order)) foreach ($order as $key) {
			if (!empty($customcontrol[$type][$key])) {
				$fieldname = $fieldnames[$key][0];
				$method = 'show_'.$fieldname;
				if (method_exists($this, $method)) {
					$count++;
					if ($dodisplay) $this->$method($file);
				}
			}
		}
		return $count;
	}
	
	function show_smalldesc ($file) {
		if ($file->smalldesc<>'') $this->fileOutputBox(_DOWN_DESC_SMALL, $file->smalldesc, !$file->autoshort);
	}
	
	function show_submittedby ($file) {
		if ($file->submittedby) {
		    $submitter =& new remositoryUser($file->submittedby);
		    $this->fileOutputBox(_DOWN_SUB_BY, $submitter->name);
        }
	}
	
	function show_submitdate ($file) {
		if ($file->submitdate<>'') $this->fileOutputBox(_DOWN_SUB_DATE, date ($this->repository->Date_Format, $this->controller->revertFullTimeStamp($file->submitdate)));
	}
	
	function show_filesize ($file) {
		if ($file->filesize<>'') $this->fileOutputBox(_DOWN_FILE_SIZE, $file->filesize);
	}
	
	function show_downloads ($file) {
		$this->fileOutputBox(_DOWN_DOWNLOADS, $file->downloads);
	}
	
	function show_license ($file) {
		if ($file->license<>'') $this->fileOutputBox(_DOWN_LICENSE, $file->license, false);
	}
	
	function show_fileversion ($file) {
		if ($file->fileversion<>'') $this->fileOutputBox(_DOWN_FILE_VER, $file->fileversion);
	}
	
	function show_fileauthor ($file) {
		if ($file->fileauthor<>'') $this->fileOutputBox(_DOWN_FILE_AUTHOR, $file->fileauthor);
	}
	
	function show_filehomepage ($file) {
		if ($file->filehomepage<>'') $this->URLDisplay (_DOWN_FILE_HOMEPAGE, $file->filehomepage);
	}
	
	function show_vote_value ($file, $terminate=true) {
		if ($this->repository->Allow_Votes) {
		echo "\n";
		?>
			<dt><?php echo _DOWN_RATING; ?></dt>
			<dd>
				<div class='remositoryrating'><?php echo $this->repository->RemositoryImageURL('stars/'.$file->evaluateVote().'.gif',64,12);
					echo _DOWN_VOTES;
					echo round($file->vote_count); ?></div>
		<?php
		if ($terminate) echo "\n\t\t\t\t</dd>";
		}
	}

	function voteDisplay (&$file, $entry, $linkfunc='fileinfo') {
		$this->show_vote_value ($file, false);
		if ($entry AND $this->remUser->isLogged() AND !$file->userVoted($this->remUser)) {
			$formurl = $this->interface->sefRelToAbs('index.php?option=com_remository&Itemid='.$this->interface->getCurrentItemid()."&func=$linkfunc&id=".$file->id);
			?>
				<div>
					<form method="post" action="<?php echo $formurl; ?>">
						<select name="user_rating" class="inputbox">
							<option value="0">?</option>
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
							<option value="4">4</option>
							<option value="5">5</option>
						</select>
						<input class="button" type="submit" name="submit_vote" value="<?php echo _DOWN_RATE_BUTTON; ?>" />
						<input type="hidden" name="id" value="<?php echo $file->id; ?>" />
					</form>
				</div>
			<?php
		}
		echo "\n\t\t\t\t</dd>";
	}

	// Not presently used in Remository, but kept here for potential value of the code
	function multiOptionList ($name, $title, $options, $current, $tooltip=null) {
		$alternatives = explode(',',$options);
		$already = explode(',', $current);
		?>
		<tr>
	    <td width="30%" valign="top" align="right">
	  	<b><?php echo $title; ?></b>&nbsp;
	    </td>
	    <td valign="top">
		<?php
		foreach ($alternatives as $one) {
			if (in_array($one,$already)) $mark = 'checked="checked"';
			else $mark = '';
			$value = $name.'_'.$one;
			echo "<input type=\"checkbox\" name=\"$value\" $mark />$one";
		}
		if ($tooltip) echo '&nbsp;'.tooltip($tooltip);
		echo '</td></tr>';
	}

	function tooltip ($text) {
		return '<a href="javascript:void(0)"  onmouseover="return escape('."'".$text."'".')">'.RemositoryRepository::RemositoryImageURL('tooltip.png').'</a>';
	}

}
