<?php

/**************************************************************
* This file is part of Remository
* Copyright (c) 2006 Martin Brampton
* Issued as open source under GNU/GPL
* For support and other information, visit http://remository.com
* To contact Martin Brampton, write to martin@remository.com
*
* Remository started life as the psx-dude script by psx-dude@psx-dude.net
* It was enhanced by Matt Smith up to version 2.10
* Since then development has been primarily by Martin Brampton,
* with contributions from other people gratefully accepted
*/

class editContainersHTML extends remositoryAdminHTML {

	function showPublishing ($container) {
		return $this->fieldset('Publishing', $this->simpleCheckBox ($container, 'published', _DOWN_PUB));
	}

	function showMetadata ($container) {
		return $this->fieldset('Metadata',
			$this->simpleInputBox(_DOWN_KEYWORDS,'keywords',$container->keywords,50).
			$this->simpleInputBox(_DOWN_WINDOW_TITLE,'windowtitle',$container->windowtitle,50)
		);
	}

	function showStorage ($container) {
		return $this->fieldset('Storage',
			$this->simpleInputBox(_DOWN_UP_ABSOLUTE_PATH,'filepath',$container->filepath,50).
			$this->simpleCheckBox($container, 'plaintext', _DOWN_UP_PLAIN_TEXT)
		);
	}

	function showAccessControl ($container, $roleselect) {
		return $this->fieldset('Access Control',
			$this->oneAccessSelector ($roleselect, 'download', 'Download roles:').
			$this->oneAccessSelector ($roleselect, 'upload', 'Upload roles:').
			$this->oneAccessSelector ($roleselect, 'edit', 'Edit roles:').
			$this->yesNoRadio (null, 'inherit', _DOWN_INHERIT)
		);
	}

	function oneAccessSelector ($roleselect, $type, $title) {
		$select = $roleselect[$type];
		$newrole = 'Add new role:';
		return <<<ACCESS_SELECTOR

		<div class="remositoryaccessselector">
		<fieldset>
			<legend>$title</legend>
			<div>
				$select
			</div>
			<div>
				<label for="new_role_$type">$newrole</label>
				<input class="inputbox" type="text" name="new_role_$type" id="new_role_$type" />
			</div>
		</fieldset>
		</div>

ACCESS_SELECTOR;

	}

	function view (&$container, $roleselect)	{
		$iconList = remositoryContainer::getIcons ();
		$this->commonScripts('description');

		if (!defined('_ALIRO_IS_PRESENT')) $formstart = <<<FORM_START

		<form method="post" name="adminForm" action="index2.php" enctype="multipart/form-data">

FORM_START;

		else $formstart = '';

		$heading = 'Remository Edit Container <span class="small">(ID='.$container->id.')</span>';
		$loctext = _DOWN_SUGGEST_LOC;
		$leftcontents = $this->narrowInputBox(_DOWN_FOLDER_NAME, 'name', $container->name, 50).
			$this->narrowInputBox(_DOWN_ALIAS.':', 'alias', $container->alias, 50).
			$this->simpleInputArea(_DOWN_DESC, _DOWN_DESC_MAX, 'description', $container->description, 50, 100, true).
			$this->simpleIcons($container, $iconList);

		echo <<<MAIN_DIV

		<div id="remositoryedit">
		$formstart
			<table class="adminheading">
				<tr>
					<th>$heading</th>
				</tr>
            </table>
		<div class="remositoryblock">&nbsp;</div>
		<strong>$loctext</strong>
		<div id="remositoryclist">
			$this->clist
		</div>
		<div id="remositorycontainermain">
			$leftcontents
		</div>

MAIN_DIV;

		echo $this->showPublishing($container);
		echo $this->showMetadata($container);
		echo $this->showStorage($container);
		echo $this->showAccessControl($container, $roleselect);

		echo <<<END_PAGE

		<input type="hidden" name="cfid" value="$container->id" />
		<input type="hidden" name="limit" value="$this->limit" />
		<input type="hidden" name="oldpath" value="$container->filepath" />
		<input type="hidden" name="option" value="com_remository" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="act" value="$this->act" />

END_PAGE;

		if (!defined('_ALIRO_IS_PRESENT')) echo '</form>';
		echo "\n\t</div>";
	}
}