<?php

class remositoryToolbar {
	var $act;
	var $task;
	// Create an instance, get the controlling parameters from the request
	function remositoryToolbar () {
		if ($this->act = remositoryRepository::GetParam ($_REQUEST, 'act', 'about'));
		else $this->act = 'about';
		if ($this->task = remositoryRepository::GetParam($_REQUEST, 'task', 'list'));
		else $this->task = 'list';
		$this->makeBar();
	}
	// create a toolbar based on the parameters found in $_REQUEST
	function makeBar () {
		$this->start();
		$act = $this->act;
		if (method_exists($this,$act)) $this->$act();
		$this->finish();
	}
	// Any initial actions
	function start () {
		remosMenuBar::startTable();
		if ('cpanel' != $this->act) remosMenuBar::custom ('cpanel', 'back.png', 'back_f2.png', _DOWN_CPANEL_RETURN, false );
	}
	// The following methods correspond exactly to the possible values
	// of 'act' in the request.  They in turn correspond to all the
	// possible options in the admin side drop down menu for Remository.
	function containers () {
		if ($this->task == 'add') $this->addMenu('Container');
		elseif ($this->task == 'edit' OR $this->task == 'apply') $this->editMenu('Container');
		else $this->listMenu('');
	}

	function classifications () {
		if ($this->task == 'add') $this->addMenu('Classif\'n');
		elseif ($this->task == 'edit') $this->editMenu('Classif\'n');
		else $this->listMenu('');
	}

	function files () {
		if (in_array($this->task, array('add','addfile','addurl'))) $this->addMenu('File');
		elseif ('dcomment' == $this->task OR 'edit' == $this->task) $this->editMenu('File');
		else $this->fileListMenu('File');
	}

	function groups () {
		if ('add' == $this->task) $this->addGroupMenu();
		elseif ('addmembers' == $this->task) $this->addmembersGroupMenu();
		elseif ($this->task == 'edit') $this->editGroupMenu();
		else $this->groupMenu();
	}

	function ftp () {
		remosMenuBar::publish( 'upload', 'Publish files' );
	}

	function uploads () {
		if ($this->task == 'edit') {
			remosMenuBar::custom ('approve1', 'apply.png', 'apply_f2.png', _APPROVE, false);
			$this->cancel_Button();
		}
		else {
			remosMenuBar::custom( 'approve', 'apply.png', 'apply_f2.png', _APPROVE, false );
			remosMenuBar::custom( 'approvep', 'publish.png', 'publish_f2.png', _DOWN_APPROVE_PUB, false );
			remosMenuBar::editList( 'edit', 'Edit Approval' );
			remosMenuBar::deleteList( '', 'delete', 'Delete Submision' );
		}
	}

	function counts () {
		$this->containers();
	}

	function downloads () {
		$this->files();
	}

	function unlinked () {
		if ($this->task == 'add') $this->addMenu('Orhpan');
		else {
			remosMenuBar::deleteList( '', 'delete', 'Delete Orphans' );
			$this->cancel_Button();
		}
	}

	function missing () {
		if ($this->task == 'add') $this->addMenu('Missing');
		else {
			remosMenuBar::deleteList( '', 'delete', 'Delete Missing Files' );
			$this->cancel_Button();
		}
	}

	function addstructure () {
		remosMenuBar::save( 'save', 'Save '.'File structure' );
	}

	function config () {
		remosMenuBar::save( 'save', 'Save Config' );
	}

	function prune () {
		remosMenuBar::save( 'save', 'Save - prune' );
	}

	// The cancel option is always formed the same way
	function cancel_Button () {
		remosMenuBar::custom( 'list', 'cancel.png', 'cancel_f2.png', _CANCEL, false );
	}

	function back_Button () {
		remosMenuBar::custom( 'back', 'back.png', 'back_f2.png', _DOWN_ABOUT, false );
	}
	// The menu for adding something is always the same apart from the text
	function addMenu ($entity) {
		remosMenuBar::save( 'save', 'Save '.$entity );
		$this->cancel_Button();
	}
	// The menu for editing something is always the same apart from the text
	function editMenu ($entity) {
		remosMenuBar::save( 'save', 'Save '.$entity );
		if ('Container' == $entity) remosMenuBar::save( 'apply', 'Apply '.$entity );
		$this->cancel_Button();
	}
	// The menu for a list of items is always the same apart from the text
	function listMenu ($entity) {
		remosMenuBar::publishList( 'publish', 'Publish '.$entity );
		remosMenuBar::unpublishList( 'unpublish', 'UnPublish '.$entity );
		remosMenuBar::addNew( 'add', 'Add '.$entity );
		remosMenuBar::editList( 'edit', 'Edit '.$entity );
		remosMenuBar::deleteList( '', 'delete', 'Delete '.$entity );
	}
	// The menu for a list of files has two different "add" options
	function fileListMenu ($entity) {
		remosMenuBar::publishList( 'publish', 'Publish File' );
		remosMenuBar::unpublishList( 'unpublish', 'UnPublish File' );
		remosMenuBar::addNew( 'addfile', 'Add Local' );
		remosMenuBar::apply( 'addurl', 'Add Remote' );
		remosMenuBar::editList( 'edit', 'Edit File' );
		remosMenuBar::deleteList( '', 'delete', 'Delete File' );
	}
    function editGroupMenu ()
    {
        remosMenuBar::deleteList('', 'delete', 'Delete');
		$this->cancel_Button();
        remosMenuBar::spacer();
        remosMenuBar::addNew('addmembers', 'Add Members');
    }

    function groupMenu ()
    {
        remosMenuBar::addNew('add', 'Add');
        remosMenuBar::editList();
		remosMenuBar::deleteList( '', 'delete', 'Delete' );
    }

    function addGroupMenu ()
    {
        remosMenuBar::save('save', 'Save');
		$this->cancel_Button();
    } 	// Any concluding actions

    function addmembersGroupMenu ()
    {
        remosMenuBar::save('save', 'Save');
		$this->cancel_Button();
    } 	// Any concluding actions

	function finish () {
		remosMenuBar::spacer();
		remosMenuBar::endTable();
	}

}

?>